/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import javax.ws.rs.core.MultivaluedMap;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientRequest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.ValidateTokenRequest;
import org.xdi.oxauth.client.ValidateTokenResponse;
import org.xdi.oxauth.model.token.ValidateTokenErrorResponseType;

public class ValidateTokenClient
extends BaseClient {
    private ValidateTokenRequest request;
    private ValidateTokenResponse response;
    private static final String mediaType = "application/json";

    public ValidateTokenClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public ValidateTokenResponse execValidateToken(String accessToken) {
        this.request = new ValidateTokenRequest();
        this.request.setAccessToken(accessToken);
        this.setRequest(this.request);
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidateTokenResponse exec() {
        this.clientRequest = new ClientRequest(this.getUrl());
        this.clientRequest.accept(mediaType);
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        if (this.request.getAccessToken() != null && !this.request.getAccessToken().isEmpty()) {
            this.clientRequest.queryParameter("access_token", (Object)this.request.getAccessToken());
        }
        try {
            this.clientResponse = this.clientRequest.get(String.class);
            int status = this.clientResponse.getStatus();
            this.response = new ValidateTokenResponse(status);
            this.response.setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
            this.setResponse(this.response);
            String entity = (String)this.clientResponse.getEntity(String.class);
            this.response.setEntity(entity);
            if (entity != null && !entity.isEmpty()) {
                JSONObject jsonObj = new JSONObject(entity);
                if (jsonObj.has("valid")) {
                    this.response.setValid(jsonObj.getBoolean("valid"));
                }
                if (jsonObj.has("expires_in")) {
                    this.response.setExpiresIn(jsonObj.getInt("expires_in"));
                }
                if (jsonObj.has("error")) {
                    this.response.setErrorType(ValidateTokenErrorResponseType.fromString((String)jsonObj.getString("error")));
                }
                if (jsonObj.has("error_description")) {
                    this.response.setErrorDescription(jsonObj.getString("error_description"));
                }
                if (jsonObj.has("error_uri")) {
                    this.response.setErrorUri(jsonObj.getString("error_uri"));
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeConnection();
        }
        return this.response;
    }

    public void setRequest(ValidateTokenRequest request) {
        super.setRequest(request);
        this.request = request;
    }
}

