/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.HashMap;
import java.util.Map;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.userinfo.Schema;

public class UserInfoRequest
extends BaseRequest {
    private String accessToken;
    private Schema schema;

    public UserInfoRequest(String accessToken, Schema schema) {
        this.accessToken = accessToken;
        this.schema = schema;
        this.setAuthorizationMethod(AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public String getQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        if (!(this.accessToken == null || this.accessToken.isEmpty() || this.getAuthorizationMethod() != AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER && this.getAuthorizationMethod() != AuthorizationMethod.URL_QUERY_PARAMETER)) {
            queryStringBuilder.append("access_token=").append(this.accessToken);
        }
        if (this.schema != null) {
            if (queryStringBuilder.length() > 0) {
                queryStringBuilder.append("&");
            }
            queryStringBuilder.append("schema=").append(this.schema.toString());
        }
        return queryStringBuilder.toString();
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (!(this.accessToken == null || this.accessToken.isEmpty() || this.getAuthorizationMethod() != AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER && this.getAuthorizationMethod() != AuthorizationMethod.URL_QUERY_PARAMETER)) {
            parameters.put("access_token", this.accessToken);
        }
        if (this.schema != null) {
            parameters.put("schema", this.schema.toString());
        }
        return parameters;
    }
}

