/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientRequest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.UserInfoRequest;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.jwe.Jwe;
import org.xdi.oxauth.model.jws.JwsValidator;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.userinfo.Schema;
import org.xdi.oxauth.model.userinfo.UserInfoErrorResponseType;

public class UserInfoClient
extends BaseClient {
    private UserInfoRequest request;
    private UserInfoResponse response;
    private String sharedKey;
    private RSAPrivateKey rsaPrivateKey;

    public UserInfoClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        if (this.request.getAuthorizationMethod() == null || this.request.getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || this.request.getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
            return "POST";
        }
        return "GET";
    }

    public UserInfoResponse execUserInfo(String accessToken, Schema schema) {
        this.request = new UserInfoRequest(accessToken, schema);
        this.setRequest(this.request);
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserInfoResponse exec() {
        block54: {
            this.clientRequest = new ClientRequest(this.getUrl());
            this.clientRequest.header("Content-Type", (Object)"application/x-www-form-urlencoded");
            this.clientRequest.setHttpMethod(this.getHttpMethod());
            if (this.request.getAuthorizationMethod() == null || this.request.getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD) {
                if (this.request.getAccessToken() != null && !this.request.getAccessToken().isEmpty()) {
                    this.clientRequest.header("Authorization", (Object)("Bearer " + this.request.getAccessToken()));
                }
                if (this.request.getSchema() != null) {
                    this.clientRequest.formParameter("schema", (Object)this.request.getSchema());
                }
            } else if (this.request.getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
                if (this.request.getAccessToken() != null && !this.request.getAccessToken().isEmpty()) {
                    this.clientRequest.formParameter("access_token", (Object)this.request.getAccessToken());
                }
                if (this.request.getSchema() != null) {
                    this.clientRequest.formParameter("schema", (Object)this.request.getSchema());
                }
            } else if (this.request.getAuthorizationMethod() == AuthorizationMethod.URL_QUERY_PARAMETER) {
                if (this.request.getAccessToken() != null && !this.request.getAccessToken().isEmpty()) {
                    this.clientRequest.queryParameter("access_token", (Object)this.request.getAccessToken());
                }
                if (this.request.getSchema() != null) {
                    this.clientRequest.queryParameter("schema", (Object)this.request.getSchema());
                }
            }
            try {
                this.clientResponse = this.request.getAuthorizationMethod() == null || this.request.getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || this.request.getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER ? this.clientRequest.post(String.class) : this.clientRequest.get(String.class);
                int status = this.clientResponse.getStatus();
                this.response = new UserInfoResponse(status);
                String entity = (String)this.clientResponse.getEntity(String.class);
                this.response.setEntity(entity);
                this.response.setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
                this.setResponse(this.response);
                if (entity == null || entity.equals("")) break block54;
                List contentType = (List)this.clientResponse.getHeaders().get((Object)"Content-Type");
                if (contentType != null && contentType.contains("application/jwt")) {
                    String[] jwtParts = entity.split("\\.");
                    if (jwtParts.length == 5) {
                        byte[] sharedSymmetricKey = this.sharedKey != null ? this.sharedKey.getBytes("UTF-8") : null;
                        Jwe jwe = Jwe.parse((String)entity, (RSAPrivateKey)this.rsaPrivateKey, (byte[])sharedSymmetricKey);
                        this.response.setClaims(jwe.getClaims().toMap());
                    } else {
                        Jwt jwt = Jwt.parse((String)entity);
                        JwsValidator jwtValidator = new JwsValidator(jwt, this.sharedKey);
                        if (jwtValidator.validateSignature()) {
                            this.response.setClaims(jwt.getClaims().toMap());
                        }
                    }
                    break block54;
                }
                try {
                    JSONObject jsonObj = new JSONObject(entity);
                    if (jsonObj.has("sub")) {
                        this.response.setSubject(jsonObj.getString("sub"));
                    }
                    if (jsonObj.has("name")) {
                        this.response.setName(jsonObj.getString("name"));
                    }
                    if (jsonObj.has("given_name")) {
                        this.response.setGivenName(jsonObj.getString("given_name"));
                    }
                    if (jsonObj.has("family_name")) {
                        this.response.setFamilyName(jsonObj.getString("family_name"));
                    }
                    if (jsonObj.has("middle_name")) {
                        this.response.setMiddleName(jsonObj.getString("middle_name"));
                    }
                    if (jsonObj.has("nickname")) {
                        this.response.setNickname(jsonObj.getString("nickname"));
                    }
                    if (jsonObj.has("preferred_username")) {
                        this.response.setPreferredUsername(jsonObj.getString("preferred_username"));
                    }
                    if (jsonObj.has("profile")) {
                        this.response.setProfile(jsonObj.getString("profile"));
                    }
                    if (jsonObj.has("picture")) {
                        this.response.setPicture(jsonObj.getString("picture"));
                    }
                    if (jsonObj.has("website")) {
                        this.response.setWebsite(jsonObj.getString("website"));
                    }
                    if (jsonObj.has("email")) {
                        this.response.setEmail(jsonObj.getString("email"));
                    }
                    if (jsonObj.has("email_verified")) {
                        this.response.setVerified(jsonObj.getBoolean("email_verified"));
                    }
                    if (jsonObj.has("gender")) {
                        this.response.setGender(jsonObj.getString("gender"));
                    }
                    if (jsonObj.has("birthdate")) {
                        this.response.setBirthDay(jsonObj.getString("birthdate"));
                    }
                    if (jsonObj.has("zoneinfo")) {
                        this.response.setZoneInfo(jsonObj.getString("zoneinfo"));
                    }
                    if (jsonObj.has("locale")) {
                        this.response.setLocale(jsonObj.getString("locale"));
                    }
                    if (jsonObj.has("phone_number")) {
                        this.response.setPhoneNumber(jsonObj.getString("phone_number"));
                    }
                    if (jsonObj.has("updated_time")) {
                        this.response.setUpdatedTime(jsonObj.getString("updated_time"));
                    }
                    if (jsonObj.has("formatted")) {
                        this.response.setFormattedAddress(jsonObj.getString("formatted"));
                    }
                    if (jsonObj.has("street_address")) {
                        this.response.setStreetAddress(jsonObj.getString("street_address"));
                    }
                    if (jsonObj.has("locality")) {
                        this.response.setLocality(jsonObj.getString("locality"));
                    }
                    if (jsonObj.has("region")) {
                        this.response.setRegion(jsonObj.getString("region"));
                    }
                    if (jsonObj.has("postal_code")) {
                        this.response.setPostalCode(jsonObj.getString("postal_code"));
                    }
                    if (jsonObj.has("country")) {
                        this.response.setCountry(jsonObj.getString("country"));
                    }
                    if (jsonObj.has("error")) {
                        this.response.setErrorType(UserInfoErrorResponseType.fromString((String)jsonObj.getString("error")));
                        jsonObj.remove("error");
                    }
                    if (jsonObj.has("error_description")) {
                        this.response.setErrorDescription(jsonObj.getString("error_description"));
                        jsonObj.remove("error_description");
                    }
                    if (jsonObj.has("error_uri")) {
                        this.response.setErrorUri(jsonObj.getString("error_uri"));
                        jsonObj.remove("error_uri");
                    }
                    Iterator iterator = jsonObj.keys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        ArrayList<String> values = new ArrayList<String>();
                        JSONArray jsonArray = jsonObj.optJSONArray(key);
                        if (jsonArray != null) {
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                String value = jsonArray.optString(i);
                                if (value == null) continue;
                                values.add(value);
                            }
                        } else {
                            String value = jsonObj.optString(key);
                            if (value != null) {
                                values.add(value);
                            }
                        }
                        this.response.getClaims().put(key, values);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        }
        return this.response;
    }

    public void setRequest(UserInfoRequest request) {
        super.setRequest(request);
        this.request = request;
    }

    public void setSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
    }

    public void setRsaPrivateKey(RSAPrivateKey rsaPrivateKey) {
        this.rsaPrivateKey = rsaPrivateKey;
    }
}

