/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import javax.ws.rs.core.MultivaluedMap;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientRequest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.TokenType;
import org.xdi.oxauth.model.token.ClientAssertionType;
import org.xdi.oxauth.model.token.TokenErrorResponseType;

public class TokenClient
extends BaseClient {
    private TokenRequest request;
    private TokenResponse response;

    public TokenClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public TokenResponse execAuthorizationCode(String code, String redirectUri, String clientId, String clientSecret) {
        this.request = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        this.request.setCode(code);
        this.request.setRedirectUri(redirectUri);
        this.request.setAuthUsername(clientId);
        this.request.setAuthPassword(clientSecret);
        this.setRequest(this.request);
        return this.exec();
    }

    public TokenResponse execResourceOwnerPasswordCredentialsGrant(String username, String password, String scope, String clientId, String clientSecret) {
        this.request = new TokenRequest(GrantType.PASSWORD);
        this.request.setUsername(username);
        this.request.setPassword(password);
        this.request.setScope(scope);
        this.request.setAuthUsername(clientId);
        this.request.setAuthPassword(clientSecret);
        this.setRequest(this.request);
        return this.exec();
    }

    public TokenResponse execClientCredentialsGrant(String scope, String clientId, String clientSecret) {
        this.request = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        this.request.setScope(scope);
        this.request.setAuthUsername(clientId);
        this.request.setAuthPassword(clientSecret);
        this.setRequest(this.request);
        return this.exec();
    }

    public TokenResponse execExtensionGrant(String grantTypeUri, String assertion, String clientId, String clientSecret) {
        GrantType grantType = GrantType.fromString((String)grantTypeUri);
        this.request = new TokenRequest(grantType);
        this.request.setAssertion(assertion);
        this.request.setAuthUsername(clientId);
        this.request.setAuthPassword(clientSecret);
        this.setRequest(this.request);
        return this.exec();
    }

    public TokenResponse execRefreshToken(String scope, String refreshToken, String clientId, String clientSecret) {
        this.request = new TokenRequest(GrantType.REFRESH_TOKEN);
        this.request.setScope(scope);
        this.request.setRefreshToken(refreshToken);
        this.request.setAuthUsername(clientId);
        this.request.setAuthPassword(clientSecret);
        this.setRequest(this.request);
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenResponse exec() {
        block32: {
            this.clientRequest = new ClientRequest(this.getUrl());
            if (this.request.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_BASIC && this.request.hasCredentials()) {
                this.clientRequest.header("Authorization", (Object)("Basic " + this.request.getEncodedCredentials()));
            }
            this.clientRequest.header("Content-Type", (Object)"application/x-www-form-urlencoded");
            this.clientRequest.setHttpMethod(this.getHttpMethod());
            if (this.request.getGrantType() != null) {
                this.clientRequest.formParameter("grant_type", (Object)this.request.getGrantType());
            }
            if (this.request.getCode() != null && !this.request.getCode().isEmpty()) {
                this.clientRequest.formParameter("code", (Object)this.request.getCode());
            }
            if (this.request.getRedirectUri() != null && !this.request.getRedirectUri().isEmpty()) {
                this.clientRequest.formParameter("redirect_uri", (Object)this.request.getRedirectUri());
            }
            if (this.request.getUsername() != null && !this.request.getUsername().isEmpty()) {
                this.clientRequest.formParameter("username", (Object)this.request.getUsername());
            }
            if (this.request.getPassword() != null && !this.request.getPassword().isEmpty()) {
                this.clientRequest.formParameter("password", (Object)this.request.getPassword());
            }
            if (this.request.getScope() != null && !this.request.getScope().isEmpty()) {
                this.clientRequest.formParameter("scope", (Object)this.request.getScope());
            }
            if (this.request.getAssertion() != null && !this.request.getAssertion().isEmpty()) {
                this.clientRequest.formParameter("assertion", (Object)this.request.getAssertion());
            }
            if (this.request.getRefreshToken() != null && !this.request.getRefreshToken().isEmpty()) {
                this.clientRequest.formParameter("refresh_token", (Object)this.request.getRefreshToken());
            }
            if (this.request.getOxAuthExchangeToken() != null && !this.request.getOxAuthExchangeToken().isEmpty()) {
                this.clientRequest.formParameter("oxauth_exchange_token", (Object)this.request.getOxAuthExchangeToken());
            }
            if (this.request.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_POST) {
                if (this.request.getAuthUsername() != null && !this.request.getAuthUsername().isEmpty()) {
                    this.clientRequest.formParameter("client_id", (Object)this.request.getAuthUsername());
                }
                if (this.request.getAuthPassword() != null && !this.request.getAuthPassword().isEmpty()) {
                    this.clientRequest.formParameter("client_secret", (Object)this.request.getAuthPassword());
                }
            } else if (this.request.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_JWT) {
                this.clientRequest.formParameter("client_assertion_type", (Object)ClientAssertionType.JWT_BEARER);
                this.clientRequest.formParameter("client_assertion", (Object)this.request.getClientAssertion());
            }
            for (String key : this.request.getCustomParameters().keySet()) {
                this.clientRequest.formParameter(key, (Object)this.request.getCustomParameters().get(key));
            }
            try {
                this.clientResponse = this.clientRequest.post(String.class);
                int status = this.clientResponse.getStatus();
                this.response = new TokenResponse(status);
                this.response.setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
                this.setResponse(this.response);
                String entity = (String)this.clientResponse.getEntity(String.class);
                this.response.setEntity(entity);
                this.response.setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
                if (entity == null || entity.isEmpty()) break block32;
                try {
                    JSONObject jsonObj = new JSONObject(entity);
                    if (jsonObj.has("access_token")) {
                        this.response.setAccessToken(jsonObj.getString("access_token"));
                    }
                    if (jsonObj.has("token_type")) {
                        this.response.setTokenType(TokenType.fromString((String)jsonObj.getString("token_type")));
                    }
                    if (jsonObj.has("expires_in")) {
                        this.response.setExpiresIn(jsonObj.getInt("expires_in"));
                    }
                    if (jsonObj.has("refresh_token")) {
                        this.response.setRefreshToken(jsonObj.getString("refresh_token"));
                    }
                    if (jsonObj.has("scope")) {
                        this.response.setScope(jsonObj.getString("scope"));
                    }
                    if (jsonObj.has("id_token")) {
                        this.response.setIdToken(jsonObj.getString("id_token"));
                    }
                    if (jsonObj.has("error")) {
                        this.response.setErrorType(TokenErrorResponseType.fromString((String)jsonObj.getString("error")));
                    }
                    if (jsonObj.has("error_description")) {
                        this.response.setErrorDescription(jsonObj.getString("error_description"));
                    }
                    if (jsonObj.has("error_uri")) {
                        this.response.setErrorUri(jsonObj.getString("error_uri"));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        }
        return this.response;
    }

    public void setRequest(TokenRequest request) {
        super.setRequest(request);
        this.request = request;
    }
}

