/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.util.StringUtils;

public class RegisterRequest
extends BaseRequest {
    private String clientId;
    private String accessToken;
    private List<String> redirectUris = new ArrayList<String>();
    private List<ResponseType> responseTypes = new ArrayList<ResponseType>();
    private List<GrantType> grantTypes = new ArrayList<GrantType>();
    private ApplicationType applicationType;
    private List<String> contacts = new ArrayList<String>();
    private String clientName;
    private String logoUri;
    private AuthenticationMethod tokenEndpointAuthMethod;
    private String policyUri;
    private String tosUri;
    private String jwksUri;
    private String sectorIdentifierUri;
    private SubjectType subjectType;
    private SignatureAlgorithm requestObjectSigningAlg;
    private SignatureAlgorithm userInfoSignedResponseAlg;
    private KeyEncryptionAlgorithm userInfoEncryptedResponseAlg;
    private BlockEncryptionAlgorithm userInfoEncryptedResponseEnc;
    private SignatureAlgorithm idTokenSignedResponseAlg;
    private KeyEncryptionAlgorithm idTokenEncryptedResponseAlg;
    private BlockEncryptionAlgorithm idTokenEncryptedResponseEnc;
    private Integer defaultMaxAge;
    private Boolean requireAuthTime;
    private List<String> defaultAcrValues = new ArrayList<String>();
    private String initiateLoginUri;
    private String postLogoutRedirectUrl;
    private List<String> requestUris = new ArrayList<String>();
    private String federationId;
    private String federationUrl;
    private Map<String, String> customAttributes = new HashMap<String, String>();
    private boolean useBearerToken = true;

    private RegisterRequest() {
    }

    public RegisterRequest(ApplicationType applicationType, String clientName, List<String> redirectUris) {
        this();
        this.applicationType = applicationType;
        this.clientName = clientName;
        this.redirectUris = redirectUris;
    }

    public RegisterRequest(String clientId, String accessToken) {
        this();
        this.clientId = clientId;
        this.accessToken = accessToken;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public List<ResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(List<ResponseType> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public List<GrantType> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(List<GrantType> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public List<String> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<String> contacts) {
        this.contacts = contacts;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getLogoUri() {
        return this.logoUri;
    }

    public void setLogoUri(String logoUri) {
        this.logoUri = logoUri;
    }

    public AuthenticationMethod getTokenEndpointAuthMethod() {
        return this.tokenEndpointAuthMethod;
    }

    public void setTokenEndpointAuthMethod(AuthenticationMethod tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
    }

    public String getPolicyUri() {
        return this.policyUri;
    }

    public void setPolicyUri(String policyUri) {
        this.policyUri = policyUri;
    }

    public String getTosUri() {
        return this.tosUri;
    }

    public void setTosUri(String tosUri) {
        this.tosUri = tosUri;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
    }

    public SubjectType getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(SubjectType subjectType) {
        this.subjectType = subjectType;
    }

    public SignatureAlgorithm getRequestObjectSigningAlg() {
        return this.requestObjectSigningAlg;
    }

    public void setRequestObjectSigningAlg(SignatureAlgorithm requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
    }

    public SignatureAlgorithm getUserInfoSignedResponseAlg() {
        return this.userInfoSignedResponseAlg;
    }

    public void setUserInfoSignedResponseAlg(SignatureAlgorithm userInfoSignedResponseAlg) {
        this.userInfoSignedResponseAlg = userInfoSignedResponseAlg;
    }

    public KeyEncryptionAlgorithm getUserInfoEncryptedResponseAlg() {
        return this.userInfoEncryptedResponseAlg;
    }

    public void setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm userInfoEncryptedResponseAlg) {
        this.userInfoEncryptedResponseAlg = userInfoEncryptedResponseAlg;
    }

    public BlockEncryptionAlgorithm getUserInfoEncryptedResponseEnc() {
        return this.userInfoEncryptedResponseEnc;
    }

    public void setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm userInfoEncryptedResponseEnc) {
        this.userInfoEncryptedResponseEnc = userInfoEncryptedResponseEnc;
    }

    public SignatureAlgorithm getIdTokenSignedResponseAlg() {
        return this.idTokenSignedResponseAlg;
    }

    public void setIdTokenSignedResponseAlg(SignatureAlgorithm idTokenSignedResponseAlg) {
        this.idTokenSignedResponseAlg = idTokenSignedResponseAlg;
    }

    public KeyEncryptionAlgorithm getIdTokenEncryptedResponseAlg() {
        return this.idTokenEncryptedResponseAlg;
    }

    public void setIdTokenEncryptedResponseAlg(KeyEncryptionAlgorithm idTokenEncryptedResponseAlg) {
        this.idTokenEncryptedResponseAlg = idTokenEncryptedResponseAlg;
    }

    public BlockEncryptionAlgorithm getIdTokenEncryptedResponseEnc() {
        return this.idTokenEncryptedResponseEnc;
    }

    public void setIdTokenEncryptedResponseEnc(BlockEncryptionAlgorithm idTokenEncryptedResponseEnc) {
        this.idTokenEncryptedResponseEnc = idTokenEncryptedResponseEnc;
    }

    public Integer getDefaultMaxAge() {
        return this.defaultMaxAge;
    }

    public void setDefaultMaxAge(Integer defaultMaxAge) {
        this.defaultMaxAge = defaultMaxAge;
    }

    public Boolean getRequireAuthTime() {
        return this.requireAuthTime;
    }

    public void setRequireAuthTime(Boolean requireAuthTime) {
        this.requireAuthTime = requireAuthTime;
    }

    public List<String> getDefaultAcrValues() {
        return this.defaultAcrValues;
    }

    public void setDefaultAcrValues(List<String> defaultAcrValues) {
        this.defaultAcrValues = defaultAcrValues;
    }

    public String getInitiateLoginUri() {
        return this.initiateLoginUri;
    }

    public void setInitiateLoginUri(String initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
    }

    public String getPostLogoutRedirectUrl() {
        return this.postLogoutRedirectUrl;
    }

    public void setPostLogoutRedirectUrl(String postLogoutRedirectUrl) {
        this.postLogoutRedirectUrl = postLogoutRedirectUrl;
    }

    public List<String> getRequestUris() {
        return this.requestUris;
    }

    public void setRequestUris(List<String> requestUris) {
        this.requestUris = requestUris;
    }

    public String getFederationId() {
        return this.federationId;
    }

    public void setFederationId(String p_federationId) {
        this.federationId = p_federationId;
    }

    public String getFederationUrl() {
        return this.federationUrl;
    }

    public void setFederationUrl(String p_federationUrl) {
        this.federationUrl = p_federationUrl;
    }

    public Map<String, String> getCustomAttributes() {
        return Collections.unmodifiableMap(this.customAttributes);
    }

    public void addCustomAttribute(String p_name, String p_value) {
        if (RegisterRequestParam.isCustomParameterValid((String)p_name)) {
            this.customAttributes.put(p_name, p_value);
        }
    }

    public boolean isUseBearerToken() {
        return this.useBearerToken;
    }

    public void setUseBearerToken(boolean useBearerToken) {
        this.useBearerToken = useBearerToken;
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.clientId)) {
            parameters.put(RegisterRequestParam.CLIENT_ID.toString(), this.clientId);
        }
        if (!this.useBearerToken && org.apache.commons.lang.StringUtils.isNotBlank((String)this.accessToken)) {
            parameters.put(RegisterRequestParam.ACCESS_TOKEN.toString(), this.accessToken);
        }
        if (this.redirectUris != null && !this.redirectUris.isEmpty()) {
            parameters.put(RegisterRequestParam.REDIRECT_URIS.toString(), StringUtils.toJSONArray(this.redirectUris).toString());
        }
        if (this.responseTypes != null && !this.responseTypes.isEmpty()) {
            parameters.put(RegisterRequestParam.RESPONSE_TYPES.toString(), StringUtils.toJSONArray(this.responseTypes).toString());
        }
        if (this.grantTypes != null && !this.grantTypes.isEmpty()) {
            parameters.put(RegisterRequestParam.GRANT_TYPES.toString(), StringUtils.toJSONArray(this.grantTypes).toString());
        }
        if (this.applicationType != null) {
            parameters.put(RegisterRequestParam.APPLICATION_TYPE.toString(), this.applicationType.toString());
        }
        if (this.contacts != null && !this.contacts.isEmpty()) {
            parameters.put(RegisterRequestParam.CONTACTS.toString(), StringUtils.toJSONArray(this.contacts).toString());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.clientName)) {
            parameters.put(RegisterRequestParam.CLIENT_NAME.toString(), this.clientName);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.logoUri)) {
            parameters.put(RegisterRequestParam.LOGO_URI.toString(), this.logoUri);
        }
        if (this.tokenEndpointAuthMethod != null) {
            parameters.put(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString(), this.tokenEndpointAuthMethod.toString());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.policyUri)) {
            parameters.put(RegisterRequestParam.POLICY_URI.toString(), this.policyUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.tosUri)) {
            parameters.put(RegisterRequestParam.TOS_URI.toString(), this.tosUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.jwksUri)) {
            parameters.put(RegisterRequestParam.JWKS_URI.toString(), this.jwksUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.sectorIdentifierUri)) {
            parameters.put(RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString(), this.sectorIdentifierUri);
        }
        if (this.subjectType != null) {
            parameters.put(RegisterRequestParam.SUBJECT_TYPE.toString(), this.subjectType.toString());
        }
        if (this.requestObjectSigningAlg != null) {
            parameters.put(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString(), this.requestObjectSigningAlg.getName());
        }
        if (this.userInfoSignedResponseAlg != null) {
            parameters.put(RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString(), this.userInfoSignedResponseAlg.getName());
        }
        if (this.userInfoEncryptedResponseAlg != null) {
            parameters.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString(), this.userInfoEncryptedResponseAlg.getName());
        }
        if (this.userInfoEncryptedResponseEnc != null) {
            parameters.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString(), this.userInfoEncryptedResponseEnc.getName());
        }
        if (this.idTokenSignedResponseAlg != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString(), this.idTokenSignedResponseAlg.getName());
        }
        if (this.idTokenEncryptedResponseAlg != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString(), this.idTokenEncryptedResponseAlg.getName());
        }
        if (this.idTokenEncryptedResponseEnc != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString(), this.idTokenEncryptedResponseEnc.getName());
        }
        if (this.defaultMaxAge != null) {
            parameters.put(RegisterRequestParam.DEFAULT_MAX_AGE.toString(), this.defaultMaxAge.toString());
        }
        if (this.requireAuthTime != null) {
            parameters.put(RegisterRequestParam.REQUIRE_AUTH_TIME.toString(), this.requireAuthTime.toString());
        }
        if (this.defaultAcrValues != null && !this.defaultAcrValues.isEmpty()) {
            parameters.put(RegisterRequestParam.DEFAULT_ACR_VALUES.toString(), StringUtils.toJSONArray(this.defaultAcrValues).toString());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.initiateLoginUri)) {
            parameters.put(RegisterRequestParam.INITIATE_LOGIN_URI.toString(), this.initiateLoginUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.postLogoutRedirectUrl)) {
            parameters.put(RegisterRequestParam.POST_LOGOUT_REDIRECT_URI.toString(), this.postLogoutRedirectUrl);
        }
        if (this.requestUris != null && !this.requestUris.isEmpty()) {
            parameters.put(RegisterRequestParam.REQUEST_URIS.toString(), StringUtils.toJSONArray(this.requestUris).toString());
        }
        if (!org.apache.commons.lang.StringUtils.isBlank((String)this.federationUrl)) {
            parameters.put(RegisterRequestParam.FEDERATION_METADATA_URL.toString(), this.federationUrl);
        }
        if (!org.apache.commons.lang.StringUtils.isBlank((String)this.federationId)) {
            parameters.put(RegisterRequestParam.FEDERATION_METADATA_ID.toString(), this.federationId);
        }
        if (this.customAttributes != null && !this.customAttributes.isEmpty()) {
            for (Map.Entry<String, String> entry : this.customAttributes.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                if (!RegisterRequestParam.isCustomParameterValid((String)name) || !org.apache.commons.lang.StringUtils.isNotBlank((String)value)) continue;
                parameters.put(name, value);
            }
        }
        return parameters;
    }

    @Override
    public JSONObject getJSONParameters() throws JSONException {
        JSONObject parameters = new JSONObject();
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.clientId)) {
            parameters.put(RegisterRequestParam.CLIENT_ID.toString(), (Object)this.clientId);
        }
        if (!this.useBearerToken && org.apache.commons.lang.StringUtils.isNotBlank((String)this.accessToken)) {
            parameters.put(RegisterRequestParam.ACCESS_TOKEN.toString(), (Object)this.accessToken);
        }
        if (this.redirectUris != null && !this.redirectUris.isEmpty()) {
            parameters.put(RegisterRequestParam.REDIRECT_URIS.toString(), (Object)StringUtils.toJSONArray(this.redirectUris));
        }
        if (this.responseTypes != null && !this.responseTypes.isEmpty()) {
            parameters.put(RegisterRequestParam.RESPONSE_TYPES.toString(), (Object)StringUtils.toJSONArray(this.responseTypes));
        }
        if (this.grantTypes != null && !this.grantTypes.isEmpty()) {
            parameters.put(RegisterRequestParam.GRANT_TYPES.toString(), (Object)StringUtils.toJSONArray(this.grantTypes));
        }
        if (this.applicationType != null) {
            parameters.put(RegisterRequestParam.APPLICATION_TYPE.toString(), (Object)this.applicationType.toString());
        }
        if (this.contacts != null && !this.contacts.isEmpty()) {
            parameters.put(RegisterRequestParam.CONTACTS.toString(), (Object)StringUtils.toJSONArray(this.contacts));
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.clientName)) {
            parameters.put(RegisterRequestParam.CLIENT_NAME.toString(), (Object)this.clientName);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.logoUri)) {
            parameters.put(RegisterRequestParam.LOGO_URI.toString(), (Object)this.logoUri);
        }
        if (this.tokenEndpointAuthMethod != null) {
            parameters.put(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString(), (Object)this.tokenEndpointAuthMethod.toString());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.policyUri)) {
            parameters.put(RegisterRequestParam.POLICY_URI.toString(), (Object)this.policyUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.tosUri)) {
            parameters.put(RegisterRequestParam.TOS_URI.toString(), (Object)this.tosUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.jwksUri)) {
            parameters.put(RegisterRequestParam.JWKS_URI.toString(), (Object)this.jwksUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.sectorIdentifierUri)) {
            parameters.put(RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString(), (Object)this.sectorIdentifierUri);
        }
        if (this.subjectType != null) {
            parameters.put(RegisterRequestParam.SUBJECT_TYPE.toString(), (Object)this.subjectType.toString());
        }
        if (this.requestObjectSigningAlg != null) {
            parameters.put(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString(), (Object)this.requestObjectSigningAlg.getName());
        }
        if (this.userInfoSignedResponseAlg != null) {
            parameters.put(RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString(), (Object)this.userInfoSignedResponseAlg.getName());
        }
        if (this.userInfoEncryptedResponseAlg != null) {
            parameters.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString(), (Object)this.userInfoEncryptedResponseAlg.getName());
        }
        if (this.userInfoEncryptedResponseEnc != null) {
            parameters.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString(), (Object)this.userInfoEncryptedResponseEnc.getName());
        }
        if (this.idTokenSignedResponseAlg != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString(), (Object)this.idTokenSignedResponseAlg.getName());
        }
        if (this.idTokenEncryptedResponseAlg != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString(), (Object)this.idTokenEncryptedResponseAlg.getName());
        }
        if (this.idTokenEncryptedResponseEnc != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString(), (Object)this.idTokenEncryptedResponseEnc.getName());
        }
        if (this.defaultMaxAge != null) {
            parameters.put(RegisterRequestParam.DEFAULT_MAX_AGE.toString(), (Object)this.defaultMaxAge.toString());
        }
        if (this.requireAuthTime != null) {
            parameters.put(RegisterRequestParam.REQUIRE_AUTH_TIME.toString(), (Object)this.requireAuthTime.toString());
        }
        if (this.defaultAcrValues != null && !this.defaultAcrValues.isEmpty()) {
            parameters.put(RegisterRequestParam.DEFAULT_ACR_VALUES.toString(), (Object)StringUtils.toJSONArray(this.defaultAcrValues));
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.initiateLoginUri)) {
            parameters.put(RegisterRequestParam.INITIATE_LOGIN_URI.toString(), (Object)this.initiateLoginUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.postLogoutRedirectUrl)) {
            parameters.put(RegisterRequestParam.POST_LOGOUT_REDIRECT_URI.toString(), (Object)this.postLogoutRedirectUrl);
        }
        if (this.requestUris != null && !this.requestUris.isEmpty()) {
            parameters.put(RegisterRequestParam.REQUEST_URIS.toString(), (Object)StringUtils.toJSONArray(this.requestUris));
        }
        if (!org.apache.commons.lang.StringUtils.isBlank((String)this.federationUrl)) {
            parameters.put(RegisterRequestParam.FEDERATION_METADATA_URL.toString(), (Object)this.federationUrl);
        }
        if (!org.apache.commons.lang.StringUtils.isBlank((String)this.federationId)) {
            parameters.put(RegisterRequestParam.FEDERATION_METADATA_ID.toString(), (Object)this.federationId);
        }
        if (this.customAttributes != null && !this.customAttributes.isEmpty()) {
            for (Map.Entry<String, String> entry : this.customAttributes.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                if (!RegisterRequestParam.isCustomParameterValid((String)name) || !org.apache.commons.lang.StringUtils.isNotBlank((String)value)) continue;
                parameters.put(name, (Object)value);
            }
        }
        return parameters;
    }

    @Override
    public String getQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.CLIENT_ID.toString(), (Object)this.clientId);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.ACCESS_TOKEN.toString(), (Object)this.accessToken);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.REDIRECT_URIS.toString(), this.redirectUris);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.RESPONSE_TYPES.toString(), this.responseTypes);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.GRANT_TYPES.toString(), this.grantTypes);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.APPLICATION_TYPE.toString(), (Object)this.applicationType);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.CONTACTS.toString(), this.contacts);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.CLIENT_NAME.toString(), (Object)this.clientName);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.LOGO_URI.toString(), (Object)this.logoUri);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString(), (Object)this.tokenEndpointAuthMethod);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.POLICY_URI.toString(), (Object)this.policyUri);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.TOS_URI.toString(), (Object)this.tosUri);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.JWKS_URI.toString(), (Object)this.jwksUri);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString(), (Object)this.sectorIdentifierUri);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.SUBJECT_TYPE.toString(), (Object)this.subjectType);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString(), (Object)this.requestObjectSigningAlg);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString(), (Object)this.userInfoSignedResponseAlg);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString(), (Object)this.userInfoEncryptedResponseAlg);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString(), (Object)this.userInfoEncryptedResponseEnc);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString(), (Object)this.idTokenSignedResponseAlg);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString(), (Object)this.idTokenEncryptedResponseAlg);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString(), (Object)this.idTokenEncryptedResponseEnc);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.DEFAULT_MAX_AGE.toString(), (Object)this.defaultMaxAge);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.REQUIRE_AUTH_TIME.toString(), (Object)this.requireAuthTime);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.DEFAULT_ACR_VALUES.toString(), this.defaultAcrValues);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.INITIATE_LOGIN_URI.toString(), (Object)this.initiateLoginUri);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.POST_LOGOUT_REDIRECT_URI.toString(), (Object)this.postLogoutRedirectUrl);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.REQUEST_URIS.toString(), this.requestUris);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.FEDERATION_METADATA_URL.toString(), (Object)this.federationUrl);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)RegisterRequestParam.FEDERATION_METADATA_ID.toString(), (Object)this.federationId);
            if (this.customAttributes != null && !this.customAttributes.isEmpty()) {
                for (Map.Entry<String, String> entry : this.customAttributes.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    if (!RegisterRequestParam.isCustomParameterValid((String)name)) continue;
                    StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)name, (Object)value);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return queryStringBuilder.toString();
    }
}

