/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientRequest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterErrorResponseType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.register.RegisterResponseParam;

public class RegisterClient
extends BaseClient {
    private RegisterRequest request;
    private RegisterResponse response;

    public RegisterClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        if (this.request != null && this.request.getClientId() != null && this.request.getAccessToken() != null) {
            return "GET";
        }
        return "POST";
    }

    public RegisterResponse execRegister(ApplicationType applicationType, String clientName, List<String> redirectUri) {
        this.request = new RegisterRequest(applicationType, clientName, redirectUri);
        this.setRequest(this.request);
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterResponse exec() {
        block59: {
            try {
                this.clientRequest = new ClientRequest(this.getUrl());
                this.clientRequest.setHttpMethod(this.getHttpMethod());
                if (this.getHttpMethod().equals("POST")) {
                    Map<String, String> customAttributes;
                    this.clientRequest.header("Content-Type", (Object)"application/json");
                    this.clientRequest.accept("application/json");
                    JSONObject requestBody = new JSONObject();
                    if (this.request.getAccessToken() != null && !this.request.getAccessToken().isEmpty()) {
                        if (this.request.isUseBearerToken()) {
                            this.clientRequest.header("Authorization", (Object)("Bearer " + this.request.getAccessToken()));
                        } else {
                            requestBody.put(RegisterRequestParam.ACCESS_TOKEN.toString(), (Object)this.request.getAccessToken());
                        }
                    }
                    if (this.request.getRedirectUris() != null && !this.request.getRedirectUris().isEmpty()) {
                        requestBody.put(RegisterRequestParam.REDIRECT_URIS.toString(), (Object)new JSONArray(this.request.getRedirectUris()));
                    }
                    if (this.request.getResponseTypes() != null && !this.request.getResponseTypes().isEmpty()) {
                        requestBody.put(RegisterRequestParam.RESPONSE_TYPES.toString(), (Object)new JSONArray(this.request.getResponseTypes()));
                    }
                    if (this.request.getGrantTypes() != null && !this.request.getGrantTypes().isEmpty()) {
                        requestBody.put(RegisterRequestParam.GRANT_TYPES.toString(), (Object)new JSONArray(this.request.getGrantTypes()));
                    }
                    if (this.request.getApplicationType() != null) {
                        requestBody.put(RegisterRequestParam.APPLICATION_TYPE.toString(), (Object)this.request.getApplicationType());
                    }
                    if (this.request.getContacts() != null && !this.request.getContacts().isEmpty()) {
                        requestBody.put(RegisterRequestParam.CONTACTS.toString(), (Object)new JSONArray(this.request.getContacts()));
                    }
                    if (StringUtils.isNotBlank((String)this.request.getClientName())) {
                        requestBody.put(RegisterRequestParam.CLIENT_NAME.toString(), (Object)this.request.getClientName());
                    }
                    if (StringUtils.isNotBlank((String)this.request.getLogoUri())) {
                        requestBody.put(RegisterRequestParam.LOGO_URI.toString(), (Object)this.request.getLogoUri());
                    }
                    if (this.request.getTokenEndpointAuthMethod() != null) {
                        requestBody.put(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString(), (Object)this.request.getTokenEndpointAuthMethod());
                    }
                    if (StringUtils.isNotBlank((String)this.request.getPolicyUri())) {
                        requestBody.put(RegisterRequestParam.POLICY_URI.toString(), (Object)this.request.getPolicyUri());
                    }
                    if (StringUtils.isNotBlank((String)this.request.getTosUri())) {
                        requestBody.put(RegisterRequestParam.TOS_URI.toString(), (Object)this.request.getTosUri());
                    }
                    if (StringUtils.isNotBlank((String)this.request.getJwksUri())) {
                        requestBody.put(RegisterRequestParam.JWKS_URI.toString(), (Object)this.request.getJwksUri());
                    }
                    if (StringUtils.isNotBlank((String)this.request.getSectorIdentifierUri())) {
                        requestBody.put(RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString(), (Object)this.request.getSectorIdentifierUri());
                    }
                    if (this.request.getSubjectType() != null) {
                        requestBody.put(RegisterRequestParam.SUBJECT_TYPE.toString(), (Object)this.request.getSubjectType());
                    }
                    if (this.request.getRequestObjectSigningAlg() != null) {
                        requestBody.put(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString(), (Object)this.request.getRequestObjectSigningAlg().getName());
                    }
                    if (this.request.getUserInfoSignedResponseAlg() != null) {
                        requestBody.put(RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString(), (Object)this.request.getUserInfoSignedResponseAlg().getName());
                    }
                    if (this.request.getUserInfoEncryptedResponseAlg() != null) {
                        requestBody.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString(), (Object)this.request.getUserInfoEncryptedResponseAlg().getName());
                    }
                    if (this.request.getUserInfoEncryptedResponseEnc() != null) {
                        requestBody.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString(), (Object)this.request.getUserInfoEncryptedResponseEnc().getName());
                    }
                    if (this.request.getIdTokenSignedResponseAlg() != null) {
                        requestBody.put(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString(), (Object)this.request.getIdTokenSignedResponseAlg().getName());
                    }
                    if (this.request.getIdTokenEncryptedResponseAlg() != null) {
                        requestBody.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString(), (Object)this.request.getIdTokenEncryptedResponseAlg().getName());
                    }
                    if (this.request.getIdTokenEncryptedResponseEnc() != null) {
                        requestBody.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString(), (Object)this.request.getIdTokenEncryptedResponseEnc().getName());
                    }
                    if (this.request.getDefaultMaxAge() != null) {
                        requestBody.put(RegisterRequestParam.DEFAULT_MAX_AGE.toString(), (Object)this.request.getDefaultMaxAge());
                    }
                    if (this.request.getRequireAuthTime() != null) {
                        requestBody.put(RegisterRequestParam.REQUIRE_AUTH_TIME.toString(), (Object)this.request.getRequireAuthTime());
                    }
                    if (this.request.getDefaultAcrValues() != null && !this.request.getDefaultAcrValues().isEmpty()) {
                        requestBody.put(RegisterRequestParam.DEFAULT_ACR_VALUES.toString(), this.request.getDefaultAcrValues());
                    }
                    if (StringUtils.isNotBlank((String)this.request.getInitiateLoginUri())) {
                        requestBody.put(RegisterRequestParam.INITIATE_LOGIN_URI.toString(), (Object)this.request.getInitiateLoginUri());
                    }
                    if (StringUtils.isNotBlank((String)this.request.getPostLogoutRedirectUrl())) {
                        requestBody.put(RegisterRequestParam.POST_LOGOUT_REDIRECT_URI.toString(), (Object)this.request.getPostLogoutRedirectUrl());
                    }
                    if (StringUtils.isNotBlank((String)this.request.getFederationUrl())) {
                        requestBody.put(RegisterRequestParam.FEDERATION_METADATA_URL.toString(), (Object)this.request.getFederationUrl());
                    }
                    if (StringUtils.isNotBlank((String)this.request.getFederationId())) {
                        requestBody.put(RegisterRequestParam.FEDERATION_METADATA_ID.toString(), (Object)this.request.getFederationId());
                    }
                    if ((customAttributes = this.request.getCustomAttributes()) != null && !customAttributes.isEmpty()) {
                        for (Map.Entry<String, String> entry : customAttributes.entrySet()) {
                            String name = entry.getKey();
                            String value = entry.getValue();
                            if (!StringUtils.isNotBlank((String)name) || !StringUtils.isNotBlank((String)value)) continue;
                            requestBody.put(name, (Object)value);
                        }
                    }
                    this.clientRequest.body("application/json", (Object)requestBody.toString(4));
                } else {
                    this.clientRequest.accept("application/json");
                    if (this.request.getAccessToken() != null && !this.request.getAccessToken().isEmpty()) {
                        if (this.request.isUseBearerToken()) {
                            this.clientRequest.header("Authorization", (Object)("Bearer " + this.request.getAccessToken()));
                        } else {
                            this.clientRequest.queryParameter(RegisterRequestParam.ACCESS_TOKEN.toString(), (Object)this.request.getAccessToken());
                        }
                    }
                    if (StringUtils.isNotBlank((String)this.request.getClientId())) {
                        this.clientRequest.queryParameter(RegisterRequestParam.CLIENT_ID.toString(), (Object)this.request.getClientId());
                    }
                }
                this.clientResponse = this.getHttpMethod().equals("POST") ? this.clientRequest.post(String.class) : this.clientRequest.get(String.class);
                int status = this.clientResponse.getStatus();
                this.response = new RegisterResponse(status);
                String entity = (String)this.clientResponse.getEntity(String.class);
                this.response.setEntity(entity);
                this.response.setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
                this.setResponse(this.response);
                if (!StringUtils.isNotBlank((String)entity)) break block59;
                try {
                    JSONObject jsonObj = new JSONObject(entity);
                    if (jsonObj.has(RegisterResponseParam.CLIENT_ID.toString())) {
                        this.response.setClientId(jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString()));
                        jsonObj.remove(RegisterResponseParam.CLIENT_ID.toString());
                    }
                    if (jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString())) {
                        this.response.setClientSecret(jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString()));
                        jsonObj.remove(RegisterResponseParam.CLIENT_SECRET.toString());
                    }
                    if (jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString())) {
                        this.response.setRegistrationAccessToken(jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                        jsonObj.remove(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
                    }
                    if (jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString())) {
                        this.response.setRegistrationAccessUri(jsonObj.getString(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                        jsonObj.remove(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString());
                    }
                    if (jsonObj.has(RegisterResponseParam.ISSUED_AT.toString())) {
                        long issuedAt = jsonObj.getLong(RegisterResponseParam.ISSUED_AT.toString());
                        if (issuedAt > 0L) {
                            this.response.setIssuedAt(new Date(issuedAt));
                        }
                        jsonObj.remove(RegisterResponseParam.ISSUED_AT.toString());
                    }
                    if (jsonObj.has(RegisterResponseParam.EXPIRES_AT.toString())) {
                        long expiresAt = jsonObj.getLong(RegisterResponseParam.EXPIRES_AT.toString());
                        if (expiresAt > 0L) {
                            this.response.setExpiresAt(new Date(expiresAt));
                        }
                        jsonObj.remove(RegisterResponseParam.EXPIRES_AT.toString());
                    }
                    if (jsonObj.has("error")) {
                        this.response.setErrorType(RegisterErrorResponseType.fromString((String)jsonObj.getString("error")));
                        jsonObj.remove("error");
                    }
                    if (jsonObj.has("error_description")) {
                        this.response.setErrorDescription(jsonObj.getString("error_description"));
                        jsonObj.remove("error_description");
                    }
                    if (jsonObj.has("error_uri")) {
                        this.response.setErrorUri(jsonObj.getString("error_uri"));
                        jsonObj.remove("error_uri");
                    }
                    Iterator it = jsonObj.keys();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        this.response.getClaims().put(key, jsonObj.getString(key));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        }
        return this.response;
    }

    public void setRequest(RegisterRequest request) {
        super.setRequest(request);
        this.request = request;
    }
}

