/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.net.URISyntaxException;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.OpenIdConnectDiscoveryRequest;
import org.xdi.oxauth.client.OpenIdConnectDiscoveryResponse;
import org.xdi.oxauth.model.discovery.WebFingerLink;

public class OpenIdConnectDiscoveryClient
extends BaseClient {
    private OpenIdConnectDiscoveryRequest request;
    private OpenIdConnectDiscoveryResponse response;
    private static final String MEDIA_TYPE = "application/json";
    private static final String SCHEMA = "https://";
    private static final String PATH = "/.well-known/webfinger";

    public OpenIdConnectDiscoveryClient(String resource) throws URISyntaxException {
        this.request = new OpenIdConnectDiscoveryRequest(resource);
        this.setUrl(SCHEMA + this.request.getHost() + PATH);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public OpenIdConnectDiscoveryResponse exec() {
        this.setRequest(this.request);
        ClientRequest clientRequest = new ClientRequest(this.getUrl());
        clientRequest.accept(MEDIA_TYPE);
        clientRequest.setHttpMethod(this.getHttpMethod());
        if (StringUtils.isNotBlank((String)this.request.getResource())) {
            clientRequest.queryParameter("resource", (Object)this.request.getResource());
        }
        clientRequest.queryParameter("rel", (Object)"http://openid.net/specs/connect/1.0/issuer");
        try {
            ClientResponse clientResponse1 = clientRequest.get(String.class);
            int status = clientResponse1.getStatus();
            this.response = new OpenIdConnectDiscoveryResponse(status);
            String entity = (String)clientResponse1.getEntity(String.class);
            this.response.setEntity(entity);
            this.response.setHeaders((MultivaluedMap<String, String>)clientResponse1.getHeaders());
            this.setResponse(this.response);
            if (StringUtils.isNotBlank((String)entity)) {
                JSONObject jsonObj = new JSONObject(entity);
                this.response.setSubject(jsonObj.getString("subject"));
                JSONArray linksJsonArray = jsonObj.getJSONArray("links");
                for (int i = 0; i < linksJsonArray.length(); ++i) {
                    WebFingerLink webFingerLink = new WebFingerLink();
                    webFingerLink.setRel(linksJsonArray.getJSONObject(i).getString("rel"));
                    webFingerLink.setHref(linksJsonArray.getJSONObject(i).getString("href"));
                    this.response.getLinks().add(webFingerLink);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.response;
    }
}

