/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import javax.ws.rs.core.MultivaluedMap;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientRequest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.OpenIdConfigurationRequest;
import org.xdi.oxauth.client.OpenIdConfigurationResponse;
import org.xdi.oxauth.model.util.Util;

public class OpenIdConfigurationClient
extends BaseClient {
    private OpenIdConfigurationRequest request;
    private OpenIdConfigurationResponse response;
    private static final String mediaType = "text/plain";

    public OpenIdConfigurationClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenIdConfigurationResponse execOpenIdConfiguration() {
        this.request = new OpenIdConfigurationRequest();
        this.setRequest(this.request);
        this.clientRequest = new ClientRequest(this.getUrl());
        this.clientRequest.accept(mediaType);
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        try {
            this.clientResponse = this.clientRequest.get(String.class);
            int status = this.clientResponse.getStatus();
            this.response = new OpenIdConfigurationResponse(status);
            String entity = (String)this.clientResponse.getEntity(String.class);
            this.response.setEntity(entity);
            this.response.setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
            this.setResponse(this.response);
            if (entity != null && !entity.equals("")) {
                JSONObject jsonObj = new JSONObject(entity);
                if (jsonObj.has("version")) {
                    this.response.setVersion(jsonObj.getString("version"));
                }
                if (jsonObj.has("issuer")) {
                    this.response.setIssuer(jsonObj.getString("issuer"));
                }
                if (jsonObj.has("authorization_endpoint")) {
                    this.response.setAuthorizationEndpoint(jsonObj.getString("authorization_endpoint"));
                }
                if (jsonObj.has("token_endpoint")) {
                    this.response.setTokenEndpoint(jsonObj.getString("token_endpoint"));
                }
                if (jsonObj.has("userinfo_endpoint")) {
                    this.response.setUserInfoEndpoint(jsonObj.getString("userinfo_endpoint"));
                }
                if (jsonObj.has("clientinfo_endpoint")) {
                    this.response.setClientInfoEndpoint(jsonObj.getString("clientinfo_endpoint"));
                }
                if (jsonObj.has("check_session_iframe")) {
                    this.response.setCheckSessionIFrame(jsonObj.getString("check_session_iframe"));
                }
                if (jsonObj.has("end_session_endpoint")) {
                    this.response.setEndSessionEndpoint(jsonObj.getString("end_session_endpoint"));
                }
                if (jsonObj.has("jwks_uri")) {
                    this.response.setJwksUri(jsonObj.getString("jwks_uri"));
                }
                if (jsonObj.has("registration_endpoint")) {
                    this.response.setRegistrationEndpoint(jsonObj.getString("registration_endpoint"));
                }
                Util.addToListIfHas(this.response.getScopesSupported(), (JSONObject)jsonObj, (String)"scopes_supported");
                Util.addToListIfHas(this.response.getResponseTypesSupported(), (JSONObject)jsonObj, (String)"response_types_supported");
                Util.addToListIfHas(this.response.getGrantTypesSupported(), (JSONObject)jsonObj, (String)"grant_types_supported");
                Util.addToListIfHas(this.response.getAcrValuesSupported(), (JSONObject)jsonObj, (String)"acr_values_supported");
                Util.addToListIfHas(this.response.getSubjectTypesSupported(), (JSONObject)jsonObj, (String)"subject_types_supported");
                Util.addToListIfHas(this.response.getUserInfoSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"userinfo_signing_alg_values_supported");
                Util.addToListIfHas(this.response.getUserInfoEncryptionAlgValuesSupported(), (JSONObject)jsonObj, (String)"userinfo_encryption_alg_values_supported");
                Util.addToListIfHas(this.response.getUserInfoEncryptionEncValuesSupported(), (JSONObject)jsonObj, (String)"userinfo_encryption_enc_values_supported");
                Util.addToListIfHas(this.response.getIdTokenSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"id_token_signing_alg_values_supported");
                Util.addToListIfHas(this.response.getIdTokenEncryptionAlgValuesSupported(), (JSONObject)jsonObj, (String)"id_token_encryption_alg_values_supported");
                Util.addToListIfHas(this.response.getIdTokenEncryptionEncValuesSupported(), (JSONObject)jsonObj, (String)"id_token_encryption_enc_values_supported");
                Util.addToListIfHas(this.response.getRequestObjectSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"request_object_signing_alg_values_supported");
                Util.addToListIfHas(this.response.getRequestObjectEncryptionAlgValuesSupported(), (JSONObject)jsonObj, (String)"request_object_encryption_alg_values_supported");
                Util.addToListIfHas(this.response.getRequestObjectEncryptionEncValuesSupported(), (JSONObject)jsonObj, (String)"request_object_encryption_enc_values_supported");
                Util.addToListIfHas(this.response.getTokenEndpointAuthMethodsSupported(), (JSONObject)jsonObj, (String)"token_endpoint_auth_methods_supported");
                Util.addToListIfHas(this.response.getTokenEndpointAuthSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"token_endpoint_auth_signing_alg_values_supported");
                Util.addToListIfHas(this.response.getDisplayValuesSupported(), (JSONObject)jsonObj, (String)"display_values_supported");
                Util.addToListIfHas(this.response.getClaimTypesSupported(), (JSONObject)jsonObj, (String)"claim_types_supported");
                Util.addToListIfHas(this.response.getClaimsSupported(), (JSONObject)jsonObj, (String)"claims_supported");
                if (jsonObj.has("service_documentation")) {
                    this.response.setServiceDocumentation(jsonObj.getString("service_documentation"));
                }
                Util.addToListIfHas(this.response.getClaimsLocalesSupported(), (JSONObject)jsonObj, (String)"claims_locales_supported");
                Util.addToListIfHas(this.response.getUiLocalesSupported(), (JSONObject)jsonObj, (String)"ui_locales_supported");
                if (jsonObj.has("claims_parameter_supported")) {
                    this.response.setClaimsParameterSupported(jsonObj.getBoolean("claims_parameter_supported"));
                }
                if (jsonObj.has("request_parameter_supported")) {
                    this.response.setRequestParameterSupported(jsonObj.getBoolean("request_parameter_supported"));
                }
                if (jsonObj.has("request_uri_parameter_supported")) {
                    this.response.setRequestUriParameterSupported(jsonObj.getBoolean("request_uri_parameter_supported"));
                }
                if (jsonObj.has("require_request_uri_registration")) {
                    this.response.setRequireRequestUriRegistration(jsonObj.getBoolean("require_request_uri_registration"));
                }
                if (jsonObj.has("op_policy_uri")) {
                    this.response.setOpPolicyUri(jsonObj.getString("op_policy_uri"));
                }
                if (jsonObj.has("op_tos_uri")) {
                    this.response.setOpTosUri(jsonObj.getString("op_tos_uri"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeConnection();
        }
        return this.response;
    }
}

