/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.ArrayList;
import javax.ws.rs.core.MultivaluedMap;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientRequest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.JwkRequest;
import org.xdi.oxauth.client.JwkResponse;
import org.xdi.oxauth.model.crypto.PublicKey;
import org.xdi.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.jwk.JSONWebKey;
import org.xdi.oxauth.model.jwk.KeyType;
import org.xdi.oxauth.model.jwk.Use;

public class JwkClient
extends BaseClient {
    private JwkRequest request;
    private JwkResponse response;
    private static final String mediaType = "text/plain";

    public JwkClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JwkResponse exec() {
        this.request = new JwkRequest();
        this.setRequest(this.request);
        this.clientRequest = new ClientRequest(this.getUrl());
        if (this.request.hasCredentials()) {
            String encodedCredentials = this.request.getEncodedCredentials();
            this.clientRequest.header("Authorization", (Object)("Basic " + encodedCredentials));
        }
        this.clientRequest.accept(mediaType);
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        try {
            JSONObject jsonObj;
            this.clientResponse = this.clientRequest.get(String.class);
            int status = this.clientResponse.getStatus();
            this.response = new JwkResponse(status);
            this.response.setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
            this.setResponse(this.response);
            String entity = (String)this.clientResponse.getEntity(String.class);
            this.response.setEntity(entity);
            if (entity != null && !entity.equals("") && (jsonObj = new JSONObject(entity)).has("keys")) {
                JSONArray jwks = jsonObj.getJSONArray("keys");
                ArrayList<JSONWebKey> jwkList = new ArrayList<JSONWebKey>();
                for (int i = 0; i < jwks.length(); ++i) {
                    JSONObject jsonKeyValue = jwks.getJSONObject(i);
                    JSONWebKey JSONWebKey2 = new JSONWebKey();
                    if (jsonKeyValue.has("kty")) {
                        JSONWebKey2.setKeyType(KeyType.fromString((String)jsonKeyValue.getString("kty")));
                    }
                    if (jsonKeyValue.has("kid")) {
                        JSONWebKey2.setKeyId(jsonKeyValue.getString("kid"));
                    }
                    if (jsonKeyValue.has("use")) {
                        JSONWebKey2.setUse(Use.fromString((String)jsonKeyValue.getString("use")));
                    }
                    if (jsonKeyValue.has("alg")) {
                        JSONWebKey2.setAlgorithm(jsonKeyValue.getString("alg"));
                    }
                    if (jsonKeyValue.has("n")) {
                        JSONWebKey2.getPublicKey().setModulus(jsonKeyValue.getString("n"));
                    }
                    if (jsonKeyValue.has("e")) {
                        JSONWebKey2.getPublicKey().setExponent(jsonKeyValue.getString("e"));
                    }
                    if (jsonKeyValue.has("crv")) {
                        JSONWebKey2.setCurve(jsonKeyValue.getString("crv"));
                    }
                    if (jsonKeyValue.has("x")) {
                        JSONWebKey2.getPublicKey().setX(jsonKeyValue.getString("x"));
                    }
                    if (jsonKeyValue.has("y")) {
                        JSONWebKey2.getPublicKey().setY(jsonKeyValue.getString("y"));
                    }
                    jwkList.add(JSONWebKey2);
                }
                this.response.setKeys(jwkList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeConnection();
        }
        return this.response;
    }

    public static RSAPublicKey getRSAPublicKey(String jwkSetUri, String keyId) {
        PublicKey pk;
        RSAPublicKey publicKey = null;
        JwkClient jwkClient = new JwkClient(jwkSetUri);
        JwkResponse jwkResponse = jwkClient.exec();
        if (jwkResponse != null && jwkResponse.getStatus() == 200 && (pk = jwkResponse.getPublicKey(keyId)) instanceof RSAPublicKey) {
            publicKey = (RSAPublicKey)pk;
        }
        return publicKey;
    }

    public static ECDSAPublicKey getECDSAPublicKey(String jwkSetUrl, String keyId) {
        PublicKey pk;
        ECDSAPublicKey publicKey = null;
        JwkClient jwkClient = new JwkClient(jwkSetUrl);
        JwkResponse jwkResponse = jwkClient.exec();
        if (jwkResponse != null && jwkResponse.getStatus() == 200 && (pk = jwkResponse.getPublicKey(keyId)) instanceof ECDSAPublicKey) {
            publicKey = (ECDSAPublicKey)pk;
        }
        return publicKey;
    }
}

