/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.jboss.resteasy.client.ClientRequest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.FederationDataRequest;
import org.xdi.oxauth.client.FederationDataResponse;
import org.xdi.oxauth.model.federation.FederationRequest;

public class FederationDataClient
extends BaseClient {
    public FederationDataClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public FederationDataResponse joinRP(String p_federationId, String p_displayName, String p_redirectUri) {
        return this.joinRP(p_federationId, p_displayName, p_redirectUri, null, null);
    }

    public FederationDataResponse joinRP(String p_federationId, String p_displayName, String p_redirectUri, String p_x509pem, String p_x509url) {
        FederationDataRequest request = new FederationDataRequest();
        request.setType(FederationRequest.Type.RP);
        request.setFederationId(p_federationId);
        request.setDisplayName(p_displayName);
        request.setRedirectUri(p_redirectUri);
        request.setX509pem(p_x509pem);
        request.setX509url(p_x509url);
        return this.exec(request);
    }

    public FederationDataResponse joinOP(String p_federationId, String p_displayName, String p_opId, String p_domain) {
        return this.joinOP(p_federationId, p_displayName, p_opId, p_domain, null, null);
    }

    public FederationDataResponse joinOP(String p_federationId, String p_displayName, String p_opId, String p_domain, String p_x509pem, String p_x509url) {
        FederationDataRequest request = new FederationDataRequest();
        request.setType(FederationRequest.Type.OP);
        request.setFederationId(p_federationId);
        request.setDisplayName(p_displayName);
        request.setOpId(p_opId);
        request.setDomain(p_domain);
        request.setX509pem(p_x509pem);
        request.setX509url(p_x509url);
        return this.exec(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FederationDataResponse exec(FederationDataRequest p_request) {
        FederationDataResponse response;
        block8: {
            response = new FederationDataResponse();
            String httpMethod = this.getHttpMethod();
            this.clientRequest = new ClientRequest(this.getUrl());
            this.clientRequest.header("Content-Type", (Object)"application/x-www-form-urlencoded");
            this.clientRequest.setHttpMethod(httpMethod);
            try {
                if ("POST".equals(httpMethod)) {
                    FederationDataClient.putAllFormParameters(this.clientRequest, p_request);
                    this.clientResponse = this.clientRequest.post(String.class);
                    this.setRequest(p_request);
                    this.setResponse(response);
                    String entity = (String)this.clientResponse.getEntity(String.class);
                    response.setStatus(this.clientResponse.getStatus());
                    response.setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
                    response.setLocation(this.clientResponse.getLocation() != null ? this.clientResponse.getLocation().getHref() : "");
                    response.setEntity(entity);
                    if (StringUtils.isNotBlank((String)entity)) {
                        response.injectErrorIfExistSilently(entity);
                    }
                    break block8;
                }
                throw new UnsupportedOperationException("HTTP method is not supported. Method:" + httpMethod);
            }
            catch (UnsupportedOperationException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        }
        return response;
    }
}

