/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.xdi.oxauth.client.BaseRequest;

public class EndSessionRequest
extends BaseRequest {
    private String accessToken;
    private String redirectUri;
    private String state;

    public EndSessionRequest(String accessToken, String redirectUri) {
        this.accessToken = accessToken;
        this.redirectUri = redirectUri;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Override
    public String getQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        if (this.accessToken != null) {
            queryStringBuilder.append("access_token=").append(this.accessToken);
        }
        try {
            if (this.redirectUri != null) {
                queryStringBuilder.append("&");
                queryStringBuilder.append("redirect_uri=").append(URLEncoder.encode(this.redirectUri, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (this.state != null) {
            queryStringBuilder.append("&");
            queryStringBuilder.append("state=").append(this.state);
        }
        return queryStringBuilder.toString();
    }
}

