/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientRequest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.EndSessionRequest;
import org.xdi.oxauth.client.EndSessionResponse;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.model.session.EndSessionErrorResponseType;

public class EndSessionClient
extends BaseClient {
    private EndSessionRequest request;
    private EndSessionResponse response;
    private static final String mediaType = "text/plain";

    public EndSessionClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public EndSessionResponse execEndSession(String accessToken, String redirectUri, String state) {
        this.request = new EndSessionRequest(accessToken, redirectUri);
        this.request.setState(state);
        this.setRequest(this.request);
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndSessionResponse exec() {
        block16: {
            this.clientRequest = new ClientRequest(this.getUrl());
            this.clientRequest.accept(mediaType);
            this.clientRequest.setHttpMethod(this.getHttpMethod());
            if (this.request.getAccessToken() != null && !this.request.getAccessToken().isEmpty()) {
                this.clientRequest.queryParameter("access_token", (Object)this.request.getAccessToken());
            }
            if (this.request.getRedirectUri() != null && !this.request.getRedirectUri().isEmpty()) {
                this.clientRequest.queryParameter("redirect_uri", (Object)this.request.getRedirectUri());
            }
            if (this.request.getState() != null && !this.request.getState().isEmpty()) {
                this.clientRequest.queryParameter("state", (Object)this.request.getState());
            }
            try {
                this.clientResponse = this.clientRequest.get(String.class);
                int status = this.clientResponse.getStatus();
                this.response = new EndSessionResponse(status);
                String entity = (String)this.clientResponse.getEntity(String.class);
                this.response.setEntity(entity);
                this.response.setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
                this.setResponse(this.response);
                if (this.clientResponse.getLocation() != null) {
                    String queryString;
                    Map<String, String> params;
                    String location = this.clientResponse.getLocation().getHref();
                    this.response.setLocation(location);
                    int queryStringIndex = location.indexOf("?");
                    if (queryStringIndex != -1 && (params = QueryStringDecoder.decode(queryString = location.substring(queryStringIndex + 1))).containsKey("state")) {
                        this.response.setState(params.get("state"));
                    }
                }
                if (entity == null || entity.equals("")) break block16;
                try {
                    JSONObject jsonObj = new JSONObject(entity);
                    if (jsonObj.has("error")) {
                        this.response.setErrorType(EndSessionErrorResponseType.fromString((String)jsonObj.getString("error")));
                    }
                    if (jsonObj.has("error_description")) {
                        this.response.setErrorDescription(jsonObj.getString("error_description"));
                    }
                    if (jsonObj.has("error_uri")) {
                        this.response.setErrorUri(jsonObj.getString("error_uri"));
                    }
                    if (jsonObj.has("state")) {
                        this.response.setState(jsonObj.getString("state"));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        }
        return this.response;
    }
}

