/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.ArrayList;
import java.util.Iterator;
import javax.ws.rs.core.MultivaluedMap;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.ClientInfoRequest;
import org.xdi.oxauth.client.ClientInfoResponse;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.userinfo.UserInfoErrorResponseType;

public class ClientInfoClient
extends BaseClient {
    private ClientInfoRequest request;
    private ClientInfoResponse response;

    public ClientInfoClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        if (this.request.getAuthorizationMethod() == null || this.request.getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || this.request.getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
            return "POST";
        }
        return "GET";
    }

    public ClientInfoResponse execClientInfo(String accessToken) {
        this.request = new ClientInfoRequest(accessToken);
        this.setRequest(this.request);
        return this.exec();
    }

    public ClientInfoResponse exec() {
        this.clientRequest = new ClientRequest(this.getUrl());
        return this._exec();
    }

    public ClientInfoResponse exec(ClientExecutor p_executor) {
        this.clientRequest = new ClientRequest(this.getUrl(), p_executor);
        return this._exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientInfoResponse _exec() {
        block22: {
            this.clientRequest.header("Content-Type", (Object)"application/x-www-form-urlencoded");
            this.clientRequest.setHttpMethod(this.getHttpMethod());
            if (this.request.getAuthorizationMethod() == null || this.request.getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD) {
                if (this.request.getAccessToken() != null && !this.request.getAccessToken().isEmpty()) {
                    this.clientRequest.header("Authorization", (Object)("Bearer " + this.request.getAccessToken()));
                }
            } else if (this.request.getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
                if (this.request.getAccessToken() != null && !this.request.getAccessToken().isEmpty()) {
                    this.clientRequest.formParameter("access_token", (Object)this.request.getAccessToken());
                }
            } else if (this.request.getAuthorizationMethod() == AuthorizationMethod.URL_QUERY_PARAMETER && this.request.getAccessToken() != null && !this.request.getAccessToken().isEmpty()) {
                this.clientRequest.queryParameter("access_token", (Object)this.request.getAccessToken());
            }
            try {
                this.clientResponse = this.request.getAuthorizationMethod() == null || this.request.getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || this.request.getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER ? this.clientRequest.post(String.class) : this.clientRequest.get(String.class);
                int status = this.clientResponse.getStatus();
                this.response = new ClientInfoResponse(status);
                String entity = (String)this.clientResponse.getEntity(String.class);
                this.response.setEntity(entity);
                this.response.setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
                this.setResponse(this.response);
                if (entity == null || entity.equals("")) break block22;
                try {
                    JSONObject jsonObj = new JSONObject(entity);
                    if (jsonObj.has("error")) {
                        this.response.setErrorType(UserInfoErrorResponseType.fromString((String)jsonObj.getString("error")));
                        jsonObj.remove("error");
                    }
                    if (jsonObj.has("error_description")) {
                        this.response.setErrorDescription(jsonObj.getString("error_description"));
                        jsonObj.remove("error_description");
                    }
                    if (jsonObj.has("error_uri")) {
                        this.response.setErrorUri(jsonObj.getString("error_uri"));
                        jsonObj.remove("error_uri");
                    }
                    Iterator iterator = jsonObj.keys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        ArrayList<String> values = new ArrayList<String>();
                        JSONArray jsonArray = jsonObj.optJSONArray(key);
                        if (jsonArray != null) {
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                String value = jsonArray.optString(i);
                                if (value == null) continue;
                                values.add(value);
                            }
                        } else {
                            String value = jsonObj.optString(key);
                            if (value != null) {
                                values.add(value);
                            }
                        }
                        this.response.getClaims().put(key, values);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        }
        return this.response;
    }

    public void setRequest(ClientInfoRequest request) {
        super.setRequest(request);
        this.request = request;
    }
}

