/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.Date;
import javax.ws.rs.core.MultivaluedMap;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientRequest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.CheckSessionRequest;
import org.xdi.oxauth.client.CheckSessionResponse;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.session.CheckSessionErrorResponseType;

public class CheckSessionClient
extends BaseClient {
    private CheckSessionRequest request;
    private CheckSessionResponse response;

    public CheckSessionClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        if (this.request.getAuthorizationMethod() == null || this.request.getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || this.request.getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
            return "POST";
        }
        return "GET";
    }

    public CheckSessionResponse execCheckSession(String accessToken) {
        this.request = new CheckSessionRequest(accessToken);
        this.setRequest(this.request);
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckSessionResponse exec() {
        this.clientRequest = new ClientRequest(this.getUrl());
        this.clientRequest.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        if (this.request.getAccessToken() != null && !this.request.getAccessToken().isEmpty()) {
            if (this.request.getAuthorizationMethod() == null || this.request.getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD) {
                this.clientRequest.header("Authorization", (Object)("Bearer " + this.request.getAccessToken()));
            } else if (this.request.getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
                this.clientRequest.formParameter("access_token", (Object)this.request.getAccessToken());
            } else if (this.request.getAuthorizationMethod() == AuthorizationMethod.URL_QUERY_PARAMETER) {
                this.clientRequest.queryParameter("access_token", (Object)this.request.getAccessToken());
            }
        }
        try {
            this.clientResponse = this.request.getAuthorizationMethod() == null || this.request.getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || this.request.getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER ? this.clientRequest.post(String.class) : this.clientRequest.get(String.class);
            int status = this.clientResponse.getStatus();
            this.response = new CheckSessionResponse(status);
            this.response.setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
            this.setResponse(this.response);
            String entity = (String)this.clientResponse.getEntity(String.class);
            this.response.setEntity(entity);
            this.response.setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
            if (entity != null && !entity.isEmpty()) {
                JSONObject jsonObj = new JSONObject(entity);
                if (jsonObj.has("valid")) {
                    this.response.setValid(jsonObj.getBoolean("valid"));
                }
                if (jsonObj.has("iss")) {
                    this.response.setIssuer(jsonObj.getString("iss"));
                }
                if (jsonObj.has("sub")) {
                    this.response.setSubject(jsonObj.getString("sub"));
                }
                if (jsonObj.has("aud")) {
                    this.response.setAudience(jsonObj.getString("aud"));
                }
                if (jsonObj.has("exp")) {
                    this.response.setExpiration(new Date(jsonObj.getLong("exp") * 1000L));
                }
                if (jsonObj.has("iat")) {
                    this.response.setIssuedAt(new Date(jsonObj.getLong("iat") * 1000L));
                }
                if (jsonObj.has("expires_in")) {
                    this.response.setExpiresIn(jsonObj.getInt("expires_in"));
                }
                if (jsonObj.has("acr")) {
                    this.response.setAuthenticationContextClassReference(jsonObj.getString("acr"));
                }
                if (jsonObj.has("nonce")) {
                    this.response.setNonce(jsonObj.getString("nonce"));
                }
                if (jsonObj.has("auth_time")) {
                    this.response.setAuthenticationTime(jsonObj.getLong("auth_time"));
                }
                if (jsonObj.has("oxInum")) {
                    this.response.setOxInum(jsonObj.getString("oxInum"));
                }
                if (jsonObj.has("oxValidationURI")) {
                    this.response.setOxValidationUri(jsonObj.getString("oxValidationURI"));
                }
                if (jsonObj.has("oxOpenIDConnectVersion")) {
                    this.response.setOxOpenIdConnectVersion(jsonObj.getString("oxOpenIDConnectVersion"));
                }
                if (jsonObj.has("error")) {
                    this.response.setErrorType(CheckSessionErrorResponseType.fromString((String)jsonObj.getString("error")));
                }
                if (jsonObj.has("error_description")) {
                    this.response.setErrorDescription(jsonObj.getString("error_description"));
                }
                if (jsonObj.has("error_uri")) {
                    this.response.setErrorUri(jsonObj.getString("error_uri"));
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeConnection();
        }
        return this.response;
    }
}

