/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.util.Util;

public abstract class BaseRequest {
    private static final Map<String, String> EMPTY_MAP = new HashMap<String, String>();
    private static final JSONObject EMPTY_JSON_OBJECT = new JSONObject();
    private String authUsername;
    private String authPassword;
    private AuthenticationMethod authenticationMethod;
    private AuthorizationMethod authorizationMethod;
    private Map<String, String> customParameters = new HashMap<String, String>();

    protected BaseRequest() {
    }

    public String getAuthUsername() {
        return this.authUsername;
    }

    public void setAuthUsername(String authUsername) {
        this.authUsername = authUsername;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public AuthorizationMethod getAuthorizationMethod() {
        return this.authorizationMethod;
    }

    public void setAuthorizationMethod(AuthorizationMethod authorizationMethod) {
        this.authorizationMethod = authorizationMethod;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    public void addCustomParameter(String paramName, String paramValue) {
        this.customParameters.put(paramName, paramValue);
    }

    public boolean hasCredentials() {
        return this.authUsername != null && this.authPassword != null && !this.authUsername.isEmpty() && !this.authPassword.isEmpty();
    }

    public String getCredentials() throws UnsupportedEncodingException {
        return this.authUsername + ":" + this.authPassword;
    }

    public String getEncodedCredentials() {
        try {
            if (this.hasCredentials()) {
                return Base64.encodeBase64String((byte[])Util.getBytes((String)this.getCredentials()));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Map<String, String> getParameters() {
        return EMPTY_MAP;
    }

    public JSONObject getJSONParameters() throws JSONException {
        return EMPTY_JSON_OBJECT;
    }

    public abstract String getQueryString();
}

