/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.BaseResponse;
import org.xdi.oxauth.client.CheckSessionRequest;
import org.xdi.oxauth.client.UserInfoRequest;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.common.HasParamName;
import org.xdi.oxauth.model.util.Util;

public abstract class BaseClient {
    private String url;
    private BaseRequest request;
    private BaseResponse response;
    protected ClientRequest clientRequest = null;
    protected ClientResponse<String> clientResponse = null;

    public BaseClient() {
    }

    public BaseClient(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public BaseRequest getRequest() {
        return this.request;
    }

    public void setRequest(BaseRequest request) {
        this.request = request;
    }

    public BaseResponse getResponse() {
        return this.response;
    }

    public void setResponse(BaseResponse response) {
        this.response = response;
    }

    protected void addReqParam(String p_key, HasParamName p_value) {
        if (p_value != null) {
            this.addReqParam(p_key, p_value.getParamName());
        }
    }

    protected void addReqParam(String p_key, String p_value) {
        if (Util.allNotBlank((String[])new String[]{p_key, p_value})) {
            if (this.request.getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
                this.clientRequest.formParameter(p_key, (Object)p_value);
            } else {
                this.clientRequest.queryParameter(p_key, (Object)p_value);
            }
        }
    }

    public static void putAllFormParameters(ClientRequest p_clientRequest, BaseRequest p_request) {
        Map<String, String> parameters;
        if (p_clientRequest != null && p_request != null && (parameters = p_request.getParameters()) != null && !parameters.isEmpty()) {
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                p_clientRequest.formParameter(e.getKey(), (Object)e.getValue());
            }
        }
    }

    public String getRequestAsString() {
        StringBuilder sb = new StringBuilder();
        try {
            URL theUrl = new URL(this.url);
            if (this.getHttpMethod().equals("POST")) {
                AuthorizationRequest authorizationRequest;
                sb.append("POST").append(" ").append(theUrl.getPath()).append(" HTTP/1.1");
                sb.append("\n");
                sb.append("Host: ").append(theUrl.getHost());
                if (this.request instanceof AuthorizationRequest && (authorizationRequest = (AuthorizationRequest)this.request).isUseNoRedirectHeader()) {
                    sb.append("\n");
                    sb.append("X-Gluu-NoRedirect: true");
                }
                if (this.request.getAuthorizationMethod() == null) {
                    if ((this.request.getAuthenticationMethod() == null || this.request.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_BASIC) && this.request.hasCredentials()) {
                        String encodedCredentials = this.request.getEncodedCredentials();
                        sb.append("\n");
                        sb.append("Authorization: Basic ").append(encodedCredentials);
                    }
                } else if (this.request.getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD) {
                    String accessToken;
                    if (this.request instanceof CheckSessionRequest) {
                        accessToken = ((CheckSessionRequest)this.request).getAccessToken();
                        sb.append("\n");
                        sb.append("Authorization: Bearer ").append(accessToken);
                    } else if (this.request instanceof UserInfoRequest) {
                        accessToken = ((UserInfoRequest)this.request).getAccessToken();
                        sb.append("\n");
                        sb.append("Authorization: Bearer ").append(accessToken);
                    }
                }
                sb.append("\n");
                sb.append("Content-Type: ").append("application/x-www-form-urlencoded");
                sb.append("\n");
                sb.append("\n");
                sb.append(this.request.getQueryString());
            } else if (this.getHttpMethod().equals("GET")) {
                AuthorizationRequest authorizationRequest;
                sb.append("GET ").append(theUrl.getPath());
                if (this.request.getQueryString() != null) {
                    sb.append("?").append(this.request.getQueryString());
                }
                sb.append(" HTTP/1.1");
                sb.append("\n");
                sb.append("Host: ").append(theUrl.getHost());
                if (this.request instanceof AuthorizationRequest && (authorizationRequest = (AuthorizationRequest)this.request).isUseNoRedirectHeader()) {
                    sb.append("\n");
                    sb.append("X-Gluu-NoRedirect: true");
                }
                if (this.request.getAuthorizationMethod() == null) {
                    if (this.request.hasCredentials()) {
                        String encodedCredentials = this.request.getEncodedCredentials();
                        sb.append("\n");
                        sb.append("Authorization: Basic ").append(encodedCredentials);
                    }
                } else if (this.request.getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD) {
                    String accessToken;
                    if (this.request instanceof CheckSessionRequest) {
                        accessToken = ((CheckSessionRequest)this.request).getAccessToken();
                        sb.append("\n");
                        sb.append("Authorization: Bearer ").append(accessToken);
                    } else if (this.request instanceof UserInfoRequest) {
                        accessToken = ((UserInfoRequest)this.request).getAccessToken();
                        sb.append("\n");
                        sb.append("Authorization: Bearer ").append(accessToken);
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public String getResponseAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.response != null) {
            sb.append("HTTP/1.1 ").append(this.response.getStatus());
            if (this.response.getHeaders().containsKey((Object)"Content-Type")) {
                sb.append("\n");
                sb.append("Content-Type: ").append(((List)this.response.getHeaders().get((Object)"Content-Type")).toString().replace("[", "").replace("]", ""));
            }
            if (this.response.getHeaders().containsKey((Object)"Cache-Control")) {
                sb.append("\n");
                sb.append("Cache-Control: ").append(((List)this.response.getHeaders().get((Object)"Cache-Control")).toString().replace("[", "").replace("]", ""));
            }
            if (this.response.getHeaders().containsKey((Object)"Pragma")) {
                sb.append("\n");
                sb.append("Pragma: ").append(((List)this.response.getHeaders().get((Object)"Pragma")).toString().replace("[", "").replace("]", ""));
            }
            if (this.response.getLocation() != null && this.response.getStatus() == 302) {
                sb.append("\n");
                sb.append("Location: ").append(this.response.getLocation());
            }
            if (this.response.getEntity() != null) {
                sb.append("\n");
                sb.append("\n");
                sb.append(this.response.getEntity());
            }
        }
        return sb.toString();
    }

    public void closeConnection() {
        try {
            if (this.clientResponse != null) {
                this.clientResponse.releaseConnection();
            }
            if (this.clientRequest != null && this.clientRequest.getExecutor() != null) {
                this.clientRequest.getExecutor().close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract String getHttpMethod();
}

