/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.common.Display;
import org.xdi.oxauth.model.common.HasParamName;
import org.xdi.oxauth.model.common.Parameters;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.common.TokenType;

public class AuthorizeClient
extends BaseClient {
    static String NO_REDIRECT_HEADER = "X-Gluu-NoRedirect";
    private AuthorizationRequest request;
    private AuthorizationResponse response;

    public AuthorizeClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        if (this.request.getAuthorizationMethod() == null || this.request.getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || this.request.getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
            return "POST";
        }
        return "GET";
    }

    public AuthorizationResponse execAuthorizationCodeGrant(String clientId, List<String> scopes, String redirectUri, String nonce, String state, String req, String reqUri, Display display, List<Prompt> prompt) {
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.CODE);
        this.request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        this.request.setRedirectUri(redirectUri);
        this.request.setState(state);
        this.request.setRequest(req);
        this.request.setRedirectUri(reqUri);
        this.request.setDisplay(display);
        this.request.getPrompts().addAll(prompt);
        this.setRequest(this.request);
        return this.exec();
    }

    public AuthorizationResponse execImplicitGrant(String clientId, List<String> scopes, String redirectUri, String nonce, String state, String req, String reqUri, Display display, List<Prompt> prompt) {
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.TOKEN);
        this.request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        this.request.setRedirectUri(redirectUri);
        this.request.setState(state);
        this.request.setRequest(req);
        this.request.setRedirectUri(reqUri);
        this.request.setDisplay(display);
        this.request.getPrompts().addAll(prompt);
        this.setRequest(this.request);
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse exec() {
        AuthorizationResponse response = null;
        try {
            this.clientRequest = new ClientRequest(this.getUrl());
            response = this.exec_();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeConnection();
        }
        return response;
    }

    public AuthorizationResponse exec(ClientExecutor clientExecutor) {
        AuthorizationResponse response = null;
        try {
            this.clientRequest = new ClientRequest(this.getUrl(), clientExecutor);
            response = this.exec_();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    private AuthorizationResponse exec_() throws Exception {
        this.clientRequest.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        if (this.request.isUseNoRedirectHeader()) {
            this.clientRequest.header(NO_REDIRECT_HEADER, (Object)"true");
        }
        String responseTypesAsString = this.request.getResponseTypesAsString();
        String scopesAsString = this.request.getScopesAsString();
        String promptsAsString = this.request.getPromptsAsString();
        this.addReqParam("response_type", responseTypesAsString);
        this.addReqParam("client_id", this.request.getClientId());
        this.addReqParam("redirect_uri", this.request.getRedirectUri());
        if (this.request.isRequestSessionId()) {
            this.addReqParam(Parameters.REQUEST_SESSION_ID.getParamName(), Boolean.toString(this.request.isRequestSessionId()));
        }
        this.addReqParam(Parameters.SESSION_ID.getParamName(), this.request.getSessionId());
        this.addReqParam("scope", scopesAsString);
        this.addReqParam("prompt", promptsAsString);
        this.addReqParam("nonce", this.request.getNonce());
        this.addReqParam("state", this.request.getState());
        this.addReqParam("request", this.request.getRequest());
        this.addReqParam("request_uri", this.request.getRequestUri());
        this.addReqParam("display", (HasParamName)this.request.getDisplay());
        this.addReqParam("access_token", this.request.getAccessToken());
        for (String key : this.request.getCustomParameters().keySet()) {
            this.addReqParam(key, this.request.getCustomParameters().get(key));
        }
        if (this.request.getAuthorizationMethod() != AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER && this.request.hasCredentials()) {
            this.clientRequest.header("Authorization", (Object)("Basic " + this.request.getEncodedCredentials()));
        }
        this.clientResponse = this.request.getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER ? this.clientRequest.post(String.class) : this.clientRequest.get(String.class);
        int status = this.clientResponse.getStatus();
        this.response = new AuthorizationResponse(status);
        this.response.setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
        this.setResponse(this.response);
        if (this.clientResponse.getLocation() != null) {
            String location = this.clientResponse.getLocation().getHref();
            this.response.setLocation(location);
            this.proccessLocation(this.response.getLocation());
        }
        String entity = (String)this.clientResponse.getEntity(String.class);
        this.response.setEntity(entity);
        if (entity != null && !entity.equals("")) {
            try {
                JSONObject jsonObj = new JSONObject(entity);
                if (jsonObj.has("error")) {
                    this.response.setErrorType(AuthorizeErrorResponseType.fromString((String)jsonObj.getString("error")));
                }
                if (jsonObj.has("error_description")) {
                    this.response.setErrorDescription(jsonObj.getString("error_description"));
                }
                if (jsonObj.has("error_uri")) {
                    this.response.setErrorUri(jsonObj.getString("error_uri"));
                }
                if (jsonObj.has("state")) {
                    this.response.setState(jsonObj.getString("state"));
                }
                if (jsonObj.has("redirect")) {
                    this.response.setLocation(jsonObj.getString("redirect"));
                    this.proccessLocation(this.response.getLocation());
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return this.response;
    }

    private void proccessLocation(String location) throws UnsupportedEncodingException {
        Map<String, String> params = null;
        int fragmentIndex = location.indexOf("#");
        if (fragmentIndex != -1) {
            String fragment = location.substring(fragmentIndex + 1);
            params = QueryStringDecoder.decode(fragment);
        } else {
            int queryStringIndex = location.indexOf("?");
            if (queryStringIndex != -1) {
                String queryString = location.substring(queryStringIndex + 1);
                params = QueryStringDecoder.decode(queryString);
            }
        }
        if (params != null) {
            if (params.containsKey("code")) {
                this.response.setCode(params.get("code"));
            }
            if (params.containsKey(Parameters.SESSION_ID.getParamName())) {
                this.response.setSessionId(params.get(Parameters.SESSION_ID.getParamName()));
            }
            if (params.containsKey("access_token")) {
                this.response.setAccessToken(params.get("access_token"));
            }
            if (params.containsKey("token_type")) {
                this.response.setTokenType(TokenType.fromString((String)params.get("token_type")));
            }
            if (params.containsKey("expires_in")) {
                this.response.setExpiresIn(Integer.parseInt(params.get("expires_in")));
            }
            if (params.containsKey("scope")) {
                this.response.setScope(URLDecoder.decode(params.get("scope"), "UTF-8"));
            }
            if (params.containsKey("id_token")) {
                this.response.setIdToken(params.get("id_token"));
            }
            if (params.containsKey("state")) {
                this.response.setState(params.get("state"));
            }
            if (params.containsKey("error")) {
                this.response.setErrorType(AuthorizeErrorResponseType.fromString((String)params.get("error")));
            }
            if (params.containsKey("error_description")) {
                this.response.setErrorDescription(URLDecoder.decode(params.get("error_description"), "UTF-8"));
            }
            if (params.containsKey("error_uri")) {
                this.response.setErrorUri(URLDecoder.decode(params.get("error_uri"), "UTF-8"));
            }
        }
    }

    public void setRequest(AuthorizationRequest request) {
        super.setRequest(request);
        this.request = request;
    }
}

