/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.model.common.Display;
import org.xdi.oxauth.model.common.Parameters;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.util.Util;

public class AuthorizationRequest
extends BaseRequest {
    private List<ResponseType> responseTypes;
    private String clientId;
    private List<String> scopes;
    private String redirectUri;
    private String nonce;
    private String state;
    private String request;
    private String requestUri;
    private Display display;
    private List<Prompt> prompts;
    private boolean requestSessionId;
    private String sessionId;
    private String accessToken;
    private boolean useNoRedirectHeader;

    public AuthorizationRequest(List<ResponseType> responseTypes, String clientId, List<String> scopes, String redirectUri, String nonce) {
        this.responseTypes = responseTypes;
        this.clientId = clientId;
        this.scopes = scopes;
        this.redirectUri = redirectUri;
        this.nonce = nonce;
        this.prompts = new ArrayList<Prompt>();
        this.useNoRedirectHeader = false;
    }

    public List<ResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(List<ResponseType> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public boolean isRequestSessionId() {
        return this.requestSessionId;
    }

    public void setRequestSessionId(boolean p_requestSessionId) {
        this.requestSessionId = p_requestSessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String p_sessionId) {
        this.sessionId = p_sessionId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public List<Prompt> getPrompts() {
        return this.prompts;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public boolean isUseNoRedirectHeader() {
        return this.useNoRedirectHeader;
    }

    public void setUseNoRedirectHeader(boolean useNoRedirectHeader) {
        this.useNoRedirectHeader = useNoRedirectHeader;
    }

    public String getResponseTypesAsString() {
        return Util.asString(this.responseTypes);
    }

    public String getScopesAsString() {
        return Util.listAsString(this.scopes);
    }

    public String getPromptsAsString() {
        return Util.asString(this.prompts);
    }

    @Override
    public String getQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            String responseTypesAsString = this.getResponseTypesAsString();
            String scopesAsString = this.getScopesAsString();
            String promptsAsString = this.getPromptsAsString();
            if (StringUtils.isNotBlank((String)responseTypesAsString)) {
                queryStringBuilder.append("response_type=").append(URLEncoder.encode(responseTypesAsString, "UTF-8"));
            }
            if (this.clientId != null && !this.clientId.isEmpty()) {
                queryStringBuilder.append("&client_id=").append(this.clientId);
            }
            if (StringUtils.isNotBlank((String)scopesAsString)) {
                queryStringBuilder.append("&scope=").append(URLEncoder.encode(scopesAsString, "UTF-8"));
            }
            if (this.redirectUri != null && !this.redirectUri.isEmpty()) {
                queryStringBuilder.append("&redirect_uri=").append(URLEncoder.encode(this.redirectUri, "UTF-8"));
            }
            if (this.nonce != null && !this.nonce.isEmpty()) {
                queryStringBuilder.append("&nonce=").append(this.nonce);
            }
            if (this.state != null && !this.state.isEmpty()) {
                queryStringBuilder.append("&state=").append(this.state);
            }
            if (this.request != null && !this.request.isEmpty()) {
                queryStringBuilder.append("&request=").append(this.request);
            }
            if (this.requestUri != null && !this.requestUri.isEmpty()) {
                queryStringBuilder.append("&request_uri=").append(URLEncoder.encode(this.requestUri, "UTF-8"));
            }
            if (this.display != null) {
                queryStringBuilder.append("&display=").append(this.display);
            }
            if (this.requestSessionId) {
                queryStringBuilder.append(Parameters.REQUEST_SESSION_ID.nameToAppend()).append(this.requestSessionId);
            }
            if (StringUtils.isNotBlank((String)this.sessionId)) {
                queryStringBuilder.append(Parameters.SESSION_ID.nameToAppend()).append(this.sessionId);
            }
            if (StringUtils.isNotBlank((String)promptsAsString)) {
                queryStringBuilder.append("&prompt=").append(URLEncoder.encode(promptsAsString, "UTF-8"));
            }
            if (this.accessToken != null && !this.accessToken.isEmpty()) {
                queryStringBuilder.append("&access_token=").append(this.accessToken);
            }
            for (String key : this.getCustomParameters().keySet()) {
                queryStringBuilder.append("&");
                queryStringBuilder.append(key).append("=").append(this.getCustomParameters().get(key));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return queryStringBuilder.toString();
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String responseTypesAsString = this.getResponseTypesAsString();
        String scopesAsString = this.getScopesAsString();
        String promptsAsString = this.getPromptsAsString();
        if (StringUtils.isNotBlank((String)responseTypesAsString)) {
            parameters.put("response_type", responseTypesAsString);
        }
        if (this.clientId != null && !this.clientId.isEmpty()) {
            parameters.put("client_id", this.clientId);
        }
        if (StringUtils.isNotBlank((String)scopesAsString)) {
            parameters.put("scope", scopesAsString);
        }
        if (this.redirectUri != null && !this.redirectUri.isEmpty()) {
            parameters.put("redirect_uri", this.redirectUri);
        }
        if (this.nonce != null && !this.nonce.isEmpty()) {
            parameters.put("nonce", this.nonce);
        }
        if (this.state != null && !this.state.isEmpty()) {
            parameters.put("state", this.state);
        }
        if (this.request != null && !this.request.isEmpty()) {
            parameters.put("request", this.request);
        }
        if (this.requestUri != null && !this.requestUri.isEmpty()) {
            parameters.put("request_uri", this.requestUri);
        }
        if (this.display != null) {
            parameters.put("display", this.display.toString());
        }
        if (StringUtils.isNotBlank((String)promptsAsString)) {
            parameters.put("prompt", promptsAsString);
        }
        if (this.accessToken != null && !this.accessToken.isEmpty()) {
            parameters.put("access_token", this.accessToken);
        }
        if (this.requestSessionId) {
            parameters.put(Parameters.REQUEST_SESSION_ID.getParamName(), Boolean.toString(this.requestSessionId));
        }
        if (StringUtils.isNotBlank((String)this.sessionId)) {
            parameters.put(Parameters.SESSION_ID.getParamName(), this.sessionId);
        }
        for (String key : this.getCustomParameters().keySet()) {
            parameters.put(key, this.getCustomParameters().get(key));
        }
        return parameters;
    }
}

