/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.authentication.remote.saml2.selector;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.authentication.remote.saml2.Warnings;
import com.alfaariss.oa.authentication.remote.saml2.selector.DefaultSelector;
import com.alfaariss.oa.util.saml2.idp.SAML2IDP;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gluu.authentication.remote.saml2.selector.ApplicationSelectorConfiguration;
import org.w3c.dom.Element;

public class ApplicationSelector
extends DefaultSelector {
    private final Log log = LogFactory.getLog(ApplicationSelector.class);
    private ApplicationSelectorConfiguration applicationSelectorConfiguration = new ApplicationSelectorConfiguration();
    private Map<String, String> applicationMapping;

    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        super.start(oConfigurationManager, eConfig);
        this.loadApplicationMapping();
    }

    private void loadApplicationMapping() {
        try {
            this.applicationSelectorConfiguration.loadConfiguration();
            this.applicationMapping = this.applicationSelectorConfiguration.getApplicationMapping();
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot read asimba-selector.xml configuration", (Throwable)e);
        }
    }

    public SAML2IDP resolve(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession, List<SAML2IDP> listOrganizations, String sMethodName, List<Warnings> oWarnings) throws OAException {
        String requestorId = oSession.getRequestorId();
        this.log.debug((Object)("Attempting to find mapping by requestorId: " + requestorId));
        String organizationId = this.applicationMapping.get(requestorId);
        if (organizationId != null) {
            this.log.debug((Object)("Found organizationId: " + organizationId + " by requestorId: " + requestorId));
            for (SAML2IDP org : listOrganizations) {
                if (!org.getID().equals(organizationId)) continue;
                return org;
            }
        } else {
            this.log.debug((Object)("Can't find mapping by requestorId: " + requestorId));
        }
        return super.resolve(oRequest, oResponse, oSession, listOrganizations, sMethodName, oWarnings);
    }
}

