/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.authentication.remote.saml2.selector;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApplicationSelectorConfiguration {
    private static final Log log = LogFactory.getLog(ApplicationSelectorConfiguration.class);
    private final String CONFIGURATION_FILE_NAME = "asimba-selector.xml";
    private Map<String, String> applicationMapping;
    private final ReentrantLock reloadLock = new ReentrantLock();
    private boolean isReload = false;
    private long lastModTime = -1L;

    public ApplicationSelectorConfiguration() {
        this.applicationMapping = new HashMap<String, String>();
    }

    public void loadConfiguration() {
        this.applicationMapping = new HashMap<String, String>();
        String confFilePath = this.getConfigurationFilePath();
        if (confFilePath == null) {
            return;
        }
        File confFile = new File(confFilePath);
        if (this.lastModTime == confFile.lastModified()) {
            return;
        }
        this.loadFileSync(confFile);
    }

    public String getConfigurationFilePath() {
        String tomcatHome = System.getProperty("catalina.home");
        if (tomcatHome == null) {
            log.error((Object)"Failed to load mapping from 'asimba-selector.xml'. The environment variable catalina.home isn't defined");
            return null;
        }
        String confPath = System.getProperty("catalina.home") + File.separator + "conf" + File.separator + "asimba-selector.xml";
        log.info((Object)("Reading configuration from: " + confPath));
        return confPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFileSync(File confFile) {
        this.isReload = true;
        this.reloadLock.lock();
        try {
            if (!this.isReload) {
                return;
            }
            this.loadFile(confFile);
        }
        finally {
            this.reloadLock.unlock();
            this.isReload = false;
        }
    }

    private void loadFile(File confFile) {
        try {
            DocumentBuilderFactory fty = DocumentBuilderFactory.newInstance();
            fty.setNamespaceAware(true);
            DocumentBuilder builder = fty.newDocumentBuilder();
            Document xmlDoc = builder.parse(confFile);
            this.applicationMapping = this.loadIdpMapping(xmlDoc);
            this.lastModTime = confFile.lastModified();
        }
        catch (Exception ex) {
            log.error((Object)"Faield to load mapping configuration", (Throwable)ex);
        }
    }

    private Map<String, String> loadIdpMapping(Document xmlDoc) throws XPathExpressionException {
        HashMap<String, String> result = new HashMap<String, String>();
        XPath xPath = XPathFactory.newInstance().newXPath();
        XPathExpression query = xPath.compile("/asimba-selector/application");
        NodeList nodes = (NodeList)query.evaluate(xmlDoc, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node organizationIdNode;
            Node node = nodes.item(i);
            Node entityIdNode = node.getAttributes().getNamedItem("entityId");
            if (entityIdNode == null || (organizationIdNode = node.getAttributes().getNamedItem("organizationId")) == null) continue;
            result.put(entityIdNode.getNodeValue(), organizationIdNode.getNodeValue());
        }
        return result;
    }

    public Map<String, String> getApplicationMapping() {
        return this.applicationMapping;
    }
}

