/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.authentication.remote.saml2.selector;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.authentication.remote.saml2.Warnings;
import com.alfaariss.oa.util.saml2.idp.SAML2IDP;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gluu.asimba.util.ldap.LDAPUtility;
import org.gluu.asimba.util.ldap.selector.ApplicationSelectorEntry;
import org.gluu.authentication.remote.saml2.selector.ApplicationSelector;
import org.w3c.dom.Element;

public class ApplicationSelectorLDAP
extends ApplicationSelector {
    private static final Log log = LogFactory.getLog(ApplicationSelectorLDAP.class);
    private Map<String, String> applicationMappingLDAP = new HashMap<String, String>();

    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        super.start(oConfigurationManager, eConfig);
        this.loadApplicationMappingLDAP();
    }

    private void loadApplicationMappingLDAP() throws OAException {
        this.applicationMappingLDAP = new HashMap<String, String>();
        try {
            List entries = LDAPUtility.loadSelectors();
            for (ApplicationSelectorEntry entry : entries) {
                try {
                    String entityId = entry.getId();
                    String organizationId = entry.getOrganizationId();
                    if (!entry.isEnabled()) {
                        log.info((Object)("ApplicationSelector is disabled. Id: " + entityId + ", organizationId: " + organizationId));
                        continue;
                    }
                    if (this.applicationMappingLDAP.containsKey(entityId)) {
                        log.error((Object)("Duplicated ApplicationSelector. Id: " + entityId + ", organizationId: " + organizationId));
                        continue;
                    }
                    log.info((Object)("ApplicationSelector loaded. Id: " + entityId + ", organizationId: " + organizationId));
                    this.applicationMappingLDAP.put(entityId, organizationId);
                }
                catch (Exception e) {
                    log.error((Object)("Cannot read LDAP Selector, id: " + entry.getId()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot read LDAP Selectors)");
        }
    }

    public SAML2IDP resolve(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession, List<SAML2IDP> listOrganizations, String sMethodName, List<Warnings> oWarnings) throws OAException {
        String requestorId = oSession.getRequestorId();
        log.debug((Object)("Attempting to find mapping by requestorId: " + requestorId));
        String organizationId = this.applicationMappingLDAP.get(requestorId);
        if (organizationId != null) {
            log.debug((Object)("Found organizationId: " + organizationId + " by requestorId: " + requestorId));
            for (SAML2IDP org : listOrganizations) {
                if (!org.getID().equals(organizationId)) continue;
                return org;
            }
        } else {
            log.debug((Object)("Can't find mapping by requestorId: " + requestorId));
        }
        return super.resolve(oRequest, oResponse, oSession, listOrganizations, sMethodName, oWarnings);
    }
}

