package org.gluu.oxtrust.ws.rs;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gluu.oxtrust.model.association.PersonAssociation;

/**
 * Client association webService
 * 
 * @author Reda Zerrad Date: 07.23.2012
 */

@Path("/ClientAssociation")
public interface ClientAssociationWebService {

	@Path("/User/{uid}")
	@GET
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response getAssociatedClients(@Context HttpServletRequest request, @PathParam("uid") String uid) throws Exception;

	@Path("/Client/{cid}")
	@GET
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response getAssociatedPersons(@Context HttpServletRequest request, @PathParam("cid") String cid) throws Exception;

	@Path("/Associate/")
	@POST
	@Consumes({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response createAssociation(@Context HttpServletRequest request, PersonAssociation personAssociation) throws Exception;

	@PUT
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response deleteAssociation(@Context HttpServletRequest request, PersonAssociation personAssociation) throws Exception;

}
