package org.gluu.oxtrust.ws.rs;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.gluu.oxtrust.model.scim.ScimBulkOperation;

/**
 * SCIM Bulk Web service
 * 
 * @author Reda Zerrad Date: 04.18.2012
 */

@Path("/Bulk")
public interface BulkWebService {

	@POST
	@Consumes({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response bulkOperation(@Context HttpServletRequest request, ScimBulkOperation operation) throws WebApplicationException,
			MalformedURLException, URISyntaxException, JsonGenerationException, JsonMappingException, IOException, Exception;

}
