package org.gluu.oxtrust.action;

import java.io.Serializable;

import org.gluu.oxtrust.ldap.service.GroupService;
import org.gluu.oxtrust.ldap.service.OrganizationService;
import org.gluu.oxtrust.model.GluuGroup;
import org.gluu.oxtrust.model.GluuOrganization;
import org.gluu.oxtrust.util.OxTrustConstants;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.log.Log;

/**
 * SCIM Access Token retriever Action
 * 
 * @author Reda Zerrad Date: 05.14.2012
 */
@Scope(ScopeType.CONVERSATION)
@Name("scimConfigurationAction")
@Restrict("#{identity.loggedIn}")
public class ScimConfigurationAction implements Serializable {

	private static final long serialVersionUID = 6356638577562487737L;

	@Logger
	private Log log;

	private String serviceStatus, buttonValue, statusColor, authColor, authMode, groupDisplayName, groupInum;

	private boolean initialized;

	public String getGroupInum() {
		return this.groupInum;
	}

	public void setGroupInum(String groupInum) {
		this.groupInum = groupInum;
	}

	public String getGroupDisplayName() {
		return this.groupDisplayName;
	}

	public void setGroupDisplayName(String groupDisplayName) {
		this.groupDisplayName = groupDisplayName;
	}

	public String getAuthMode() {
		return this.authMode;
	}

	public void setAuthMode(String authMode) {
		this.authMode = authMode;
	}

	public String getStatusColor() {
		return this.statusColor;
	}

	public void setAuthColor(String authColor) {
		this.authColor = authColor;
	}

	public String getAuthColor() {
		return this.authColor;
	}

	public void setStatusColor(String statusColor) {
		this.statusColor = statusColor;
	}

	public String getServiceStatus() {
		return this.serviceStatus;
	}

	public void setServiceStatus(String serviceStatus) {
		this.serviceStatus = serviceStatus;
	}

	public String getButtonValue() {
		return this.buttonValue;
	}

	public void setButtonValue(String buttonValue) {
		this.buttonValue = buttonValue;
	}

	@Restrict("#{s:hasPermission('scim', 'access')}")
	public String init() {
		this.initialized = retrieveScimStatus() && retrieveButtonValue() && changeStatusColor() && retrieveAuthMode() && changeAuthColor()
				&& retrieveGroupDetails();
		if (!this.initialized) {
			return OxTrustConstants.RESULT_FAILURE;
		}

		return OxTrustConstants.RESULT_SUCCESS;
	}

	@Restrict("#{s:hasPermission('scim', 'access')}")
	public void cancel() {
	}

	private boolean retrieveGroupDetails() {

		try {
			GroupService groupService = GroupService.instance();
			OrganizationService organizationService = OrganizationService.instance();
			GluuOrganization org = organizationService.getOrganization();
			GluuGroup group = groupService.getGroupByDn(org.getScimGroup());
			if (group == null) {
				return false;
			}
			this.groupDisplayName = group.getDisplayName();
			this.groupInum = group.getInum();
		} catch (Exception ex) {
			log.error("Could not get SCIM group.", ex);

			return false;
		}

		return true;
	}

	private boolean retrieveScimStatus() {
		try {
			OrganizationService orgService;
			orgService = OrganizationService.instance();

			GluuOrganization org = orgService.getOrganization();

			if (org.getScimStatus().equalsIgnoreCase("deactivated")) {
				this.serviceStatus = "Deactivated";
			} else if (org.getScimStatus().equalsIgnoreCase("activated")) {
				this.serviceStatus = "Activated";
			} else {
				return false;
			}
		} catch (Exception ex) {
			log.error("Could not get ScimStatus : ", ex);

			return false;
		}

		return true;
	}

	private boolean retrieveButtonValue() {
		try {
			OrganizationService orgService;
			orgService = OrganizationService.instance();

			GluuOrganization org = orgService.getOrganization();
			if (org.getScimStatus().equalsIgnoreCase("activated")) {
				this.buttonValue = "Deactivate";
			} else if (org.getScimStatus().equalsIgnoreCase("deactivated")) {
				this.buttonValue = "Activate";
			} else {
				return false;
			}
		} catch (Exception ex) {
			log.error("Could not get ScimStatus : ", ex);

			return false;
		}

		return true;
	}

	@Restrict("#{s:hasPermission('scim', 'access')}")
	public String changeScimStatus() {
		try {
			OrganizationService orgService;
			orgService = OrganizationService.instance();
			GluuOrganization org = orgService.getOrganization();
			if (org.getScimStatus().equalsIgnoreCase("activated")) {
				org.setScimStatus("deactivated");
				orgService.updateOrganization(org);
			} else if (org.getScimStatus().equalsIgnoreCase("deactivated")) {
				org.setScimStatus("activated");
				orgService.updateOrganization(org);
			} else {
				return OxTrustConstants.RESULT_FAILURE;
			}
		} catch (Exception ex) {
			log.error("Could not change ScimStatus : ", ex);

			return OxTrustConstants.RESULT_FAILURE;
		}

		return init();
	}

	private boolean changeStatusColor() {
		try {
			OrganizationService orgService;
			orgService = OrganizationService.instance();
			GluuOrganization org = orgService.getOrganization();
			if (org.getScimStatus().equalsIgnoreCase("activated")) {
				this.statusColor = "green";
			} else if (org.getScimStatus().equalsIgnoreCase("deactivated")) {
				this.statusColor = "red";
			} else {
				return false;
			}
		} catch (Exception ex) {
			log.error("An Error occured : ", ex);

			return false;
		}

		return true;
	}

	private boolean changeAuthColor() {
		try {
			OrganizationService orgService;
			orgService = OrganizationService.instance();
			GluuOrganization org = orgService.getOrganization();
			if (org.getScimAuthMode().equalsIgnoreCase("basic")) {
				this.authColor = "green";
			} else if (org.getScimAuthMode().equalsIgnoreCase("bearer")) {
				this.authColor = "blue";
			} else {
				return false;
			}
		} catch (Exception ex) {
			log.error("An Error occured : ", ex);

			return false;
		}

		return true;
	}

	@Restrict("#{s:hasPermission('scim', 'access')}")
	public String changeAuthMode() {
		try {
			OrganizationService orgService;
			orgService = OrganizationService.instance();
			GluuOrganization org = orgService.getOrganization();
			if (org.getScimAuthMode().equalsIgnoreCase("bearer")) {
				org.setScimAuthMode("basic");
				orgService.updateOrganization(org);
			} else if (org.getScimAuthMode().equalsIgnoreCase("basic")) {
				org.setScimAuthMode("bearer");
				orgService.updateOrganization(org);
			} else {
				return OxTrustConstants.RESULT_FAILURE;
			}
		} catch (Exception ex) {
			log.error("Could not change ScimStatus : ", ex);

			return OxTrustConstants.RESULT_FAILURE;
		}

		return init();
	}

	private boolean retrieveAuthMode() {
		try {
			OrganizationService orgService;
			orgService = OrganizationService.instance();

			GluuOrganization org = orgService.getOrganization();

			if (org.getScimAuthMode().equalsIgnoreCase("bearer")) {
				this.authMode = "oAuth";
			} else if (org.getScimAuthMode().equalsIgnoreCase("basic")) {
				this.authMode = "Basic";
			} else {
				return false;
			}
		} catch (Exception ex) {
			log.error("Could not get ScimAuthMode : ", ex);

			return false;
		}

		return true;
	}

	public boolean isInitialized() {
		return initialized;
	}

}
