package org.gluu.oxtrust.model;

import java.io.Serializable;

public class ProfileConfiguration implements Serializable {

	private static final long serialVersionUID = 7083971450893323016L;
	private String name;
	private boolean includeAttributeStatement;
	private String signResponses;
	private String signAssertions;
	private String signRequests;
	private int assertionLifetime;
	private int assertionProxyCount;
	private String encryptNameIds;
	private String encryptAssertions;
	private String profileConfigurationCertFileName;

	public void setName(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	@Override
	public boolean equals(Object obj) {
		return (obj instanceof ProfileConfiguration) && name != null && name.equals(((ProfileConfiguration) obj).getName());
	}

	@Override
	public int hashCode() {
		return name.hashCode();
	}

	public boolean getIncludeAttributeStatement() {
		return includeAttributeStatement;
	}

	public void setIncludeAttributeStatement(boolean includeAttributeStatement) {
		this.includeAttributeStatement = includeAttributeStatement;

	}

	public String getSignResponses() {
		return this.signResponses;
	}

	public void setSignResponses(String signResponses) {
		this.signResponses = signResponses;

	}

	public String getSignAssertions() {
		return this.signAssertions;
	}

	public void setSignAssertions(String signAssertions) {
		this.signAssertions = signAssertions;
	}

	public String getSignRequests() {
		return this.signRequests;
	}

	public void setSignRequests(String signRequests) {
		this.signRequests = signRequests;

	}

	public int getAssertionLifetime() {
		return this.assertionLifetime;
	}

	public void setAssertionLifetime(int assertionLifetime) {
		this.assertionLifetime = assertionLifetime;
	}

	public String getEncryptNameIds() {
		return this.encryptNameIds;
	}

	public void setEncryptNameIds(String encryptNameIds) {
		this.encryptNameIds = encryptNameIds;

	}

	public int getAssertionProxyCount() {
		return this.assertionProxyCount;
	}

	public void setAssertionProxyCount(int assertionProxyCount) {
		this.assertionProxyCount = assertionProxyCount;
	}

	public String getEncryptAssertions() {
		return this.encryptAssertions;
	}

	public void setEncryptAssertions(String encryptAssertions) {
		this.encryptAssertions = encryptAssertions;
	}

	public void setProfileConfigurationCertFileName(String profileConfigurationCertFileName) {
		this.profileConfigurationCertFileName = profileConfigurationCertFileName;

	}

	public String getProfileConfigurationCertFileName() {
		return this.profileConfigurationCertFileName;
	}

}
