package org.gluu.oxtrust.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapAttributesList;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.ldap.model.GluuBoolean;
import org.xdi.ldap.model.GluuStatus;

/**
 * Person
 * 
 * @author Yuriy Movchan Date: 10.21.2010
 */

@LdapEntry(sortBy = { "displayName" })
@LdapObjectClass(values = { "top", "person", "organizationalPerson", "inetOrgPerson", "gluuPerson","eduPerson", "oxEntry", "oxCustomAttributes" })
public class GluuCustomPerson extends CustomEntry implements Serializable {

	private static final long serialVersionUID = -1879582184398161112L;

	private transient boolean selected;

	private String sourceServerName;

	@LdapAttribute(name = "gluuWhitePagesListed")
	private String gluuAllowPublication;

	@LdapAttribute(name = "gluuOptOuts")
	private List<String> gluuOptOuts;

	@LdapAttribute(name = "associatedClient")
	private List<String> associatedClient;

	@LdapAttributesList(name = "name", value = "values", sortByName = true, attributesConfiguration = {
			@LdapAttribute(name = "iname", ignoreDuringUpdate = true), @LdapAttribute(name = "inum", ignoreDuringUpdate = true),
			@LdapAttribute(name = "uid", ignoreDuringUpdate = true), @LdapAttribute(name = "userPassword", ignoreDuringRead = true) })
	private List<GluuCustomAttribute> customAttributes = new ArrayList<GluuCustomAttribute>();

	public List<GluuCustomAttribute> getCustomAttributes() {
		return customAttributes;
	}

	public void setCustomAttributes(List<GluuCustomAttribute> customAttributes) {
		this.customAttributes = customAttributes;
	}

	public String getInum() {
		return getAttribute("inum");
	}

	public void setInum(String value) {
		setAttribute("inum", value);
	}

	public String getIname() {
		return getAttribute("iname");
	}

	public void setIname(String value) {
		setAttribute("iname", value);
	}

	public String getUid() {
		return getAttribute("uid");
	}

	public void setUid(String value) {
		setAttribute("uid", value);
	}

	public String getDisplayName() {
		return getAttribute("displayName");
	}

	public void setDisplayName(String value) {
		setAttribute("displayName", value);
	}

	public String getMail() {
		return getAttribute("mail");
	}

	public void setMail(String value) {
		setAttribute("mail", value);
	}

	public String getNetworkPoken() {
		return getAttribute("networkPoken");
	}

	public void setNetworkPoken(String value) {
		setAttribute("networkPoken", value);
	}

	public String getCommonName() {
		return getAttribute("cn");
	}

	public void setCommonName(String value) {
		setAttribute("cn", value);
	}

	public String getGivenName() {
		return getAttribute("givenName");
	}

	public void setGivenName(String value) {
		setAttribute("givenName", value);
	}

	public GluuStatus getStatus() {
		return GluuStatus.getByValue(getAttribute("gluuStatus"));
	}

	public void setStatus(GluuStatus value) {
		setAttribute("gluuStatus", value.getValue());
	}

	public String getUserPassword() {
		return getAttribute("userPassword");
	}

	public void setUserPassword(String value) {
		setAttribute("userPassword", value);
	}

	public boolean isSelected() {
		return selected;
	}

	public void setSelected(boolean selected) {
		this.selected = selected;
	}

	public GluuBoolean getSLAManager() {
		return GluuBoolean.getByValue(getAttribute("gluuSLAManager"));
	}

	public void setSLAManager(GluuBoolean value) {
		setAttribute("gluuSLAManager", value.getValue());
	}

	public List<String> getMemberOf() {
		String[] value = {};
		for (GluuCustomAttribute attribute : customAttributes) {
			if (attribute.getName().equalsIgnoreCase("memberOf")) {
				value = attribute.getValues();
				break;
			}
		}
		return Arrays.asList(value);
	}

	public void setMemberOf(List<String> value) {
		setAttribute("memberOf", value.toArray(new String[] {}));
	}

	public String getSurname() {
		return getAttribute("sn");
	}

	public void setSurname(String value) {
		setAttribute("sn", value);
	}

	public void setTimezone(String value) {
		setAttribute("timezone", value);
	}

	public String getTimezone() {
		return getAttribute("timezone");
	}

	public void setPreferredLanguage(String value) {
		setAttribute("preferredLanguage", value);
	}

	public String getPreferredLanguage() {
		return getAttribute("preferredLanguage");
	}

	public int getAttributeIndex(String attributeName) {
		int idx = 0;
		for (GluuCustomAttribute attribute : customAttributes) {
			if (attribute.getName().equalsIgnoreCase(attributeName)) {
				return idx;
			}
			idx++;
		}

		return idx;
	}

	public String getAttribute(String attributeName) {
		String value = null;
		for (GluuCustomAttribute attribute : customAttributes) {
			if (attribute.getName().equalsIgnoreCase(attributeName)) {
				value = attribute.getValue();
				break;
			}
		}
		return value;
	}

	public String[] getAttributeArray(String attributeName) {
		GluuCustomAttribute gluuCustomAttribute = getGluuCustomAttribute(attributeName);
		if (gluuCustomAttribute == null) {
			return null;
		} else {
			return gluuCustomAttribute.getValues();
		}
	}

	public GluuCustomAttribute getGluuCustomAttribute(String attributeName) {
		for (GluuCustomAttribute gluuCustomAttribute : customAttributes) {
			if (gluuCustomAttribute.getName().equalsIgnoreCase(attributeName)) {
				return gluuCustomAttribute;
			}
		}

		return null;
	}

	public void setAttribute(String attributeName, String attributeValue) {
		GluuCustomAttribute attribute = new GluuCustomAttribute(attributeName, attributeValue);
		customAttributes.remove(attribute);
		customAttributes.add(attribute);
	}

	public void setAttribute(String attributeName, String[] attributeValue) {
		GluuCustomAttribute attribute = new GluuCustomAttribute(attributeName, attributeValue);
		customAttributes.remove(attribute);
		customAttributes.add(attribute);
	}

	@Override
	public String toString() {
		return super.toString();
	}

	public void setGluuAllowPublication(String allowPublication) {
		this.gluuAllowPublication = allowPublication;
	}

	public String getGluuAllowPublication() {
		return gluuAllowPublication;
	}

	public boolean isAllowPublication() {
		return Boolean.parseBoolean(gluuAllowPublication);
	}

	public void setAllowPublication(boolean allowPublication) {
		this.gluuAllowPublication = Boolean.toString(allowPublication);
	}

	public void setGluuOptOuts(List<String> optOuts) {
		this.gluuOptOuts = optOuts;
	}

	public List<String> getGluuOptOuts() {
		return gluuOptOuts;
	}

	public List<String> getAssociatedClient() {
		return this.associatedClient;
	}

	public void setAssociatedClient(List<String> associatedClientDNs) {
		this.associatedClient = associatedClientDNs;
	}

	public String getSourceServerName() {
		return sourceServerName;
	}

	public void setSourceServerName(String sourceServerName) {
		this.sourceServerName = sourceServerName;
	}

}
