package org.gluu.oxtrust.model;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.Transient;
import javax.validation.constraints.Min;

import org.apache.log4j.Logger;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.ldap.model.GluuBoolean;
import org.xdi.ldap.model.GluuStatus;
import org.xdi.ldap.model.InumEntry;
import org.xdi.util.security.StringEncrypter;

/**
 * GluuAppliance
 * 
 * @author Reda Zerrad Date: 08.10.2012
 */
@LdapEntry
@LdapObjectClass(values = { "top", "gluuAppliance" })
public class GluuAppliance extends InumEntry implements Serializable {

	private static final long serialVersionUID = -1817003894646725601L;

	private static final Logger log = Logger.getLogger(GluuAppliance.class);

	@LdapAttribute(ignoreDuringUpdate = true)
	private String inum;

	@LdapAttribute(ignoreDuringUpdate = true)
	private String inumFN;

	@LdapAttribute
	private String iname;

	@LdapAttribute
	private String description;

	@LdapAttribute
	private String displayName;

	@LdapAttribute(name = "o")
	private String owner;

	@LdapAttribute(name = "c")
	private String country;

	@LdapAttribute(name = "gluuFreeDiskSpace", updateOnly = true)
	private String freeDiskSpace;

	@LdapAttribute(name = "gluuFreeMemory", updateOnly = true)
	private String freeMemory;

	@LdapAttribute(name = "gluuFreeSwap", updateOnly = true)
	private String freeSwap;

	@LdapAttribute(name = "gluuGroupCount", updateOnly = true)
	private String groupCount;

	@LdapAttribute(name = "gluuHostname", updateOnly = true)
	private String hostname;

	@LdapAttribute(name = "gluuIpAddress", updateOnly = true)
	private String ipAddress;

	@LdapAttribute(name = "gluuPersonCount", updateOnly = true)
	private String personCount;

	@LdapAttribute(name = "gluuShibAssertionsIssued")
	private String shibAssertionsIssued;

	@LdapAttribute(name = "gluuShibFailedAuth")
	private String shibFailedAuth;

	@LdapAttribute(name = "gluuShibSecurityEvents")
	private String shibSecurityEvents;

	@LdapAttribute(name = "gluuShibSuccessfulAuths")
	private String shibSuccessfulAuths;

	@LdapAttribute(name = "gluuSystemUptime", updateOnly = true)
	private String systemUptime;

	@LdapAttribute(name = "gluuLastUpdate", updateOnly = true)
	private String lastUpdate;

	@LdapAttribute(name = "gluuAppliancePollingInterval")
	private String pollingInterval;

	@LdapAttribute(name = "gluuStatus", updateOnly = true)
	private GluuStatus status;

	@LdapAttribute(name = "userPassword", ignoreDuringRead = true)
	private String userPassword;

	@LdapAttribute(name = "blowfishPassword")
	private String blowfishPassword;

	@LdapAttribute(name = "gluuHTTPstatus", updateOnly = true)
	private String gluuHttpStatus;

	@LdapAttribute(name = "gluuDSstatus", updateOnly = true)
	private String gluuDSStatus;

	@LdapAttribute(name = "gluuVDSstatus", updateOnly = true)
	private String gluuVDSStatus;

	@LdapAttribute(name = "gluuBandwidthTX", updateOnly = true)
	private String gluuBandwidthTX;

	@LdapAttribute(name = "gluuBandwidthRX", updateOnly = true)
	private String gluuBandwidthRX;

	@LdapAttribute(name = "gluuSPTR")
	private String gluuSPTR;

	@LdapAttribute(name = "gluuSslExpiry", updateOnly = true)
	private String sslExpiry;

	@LdapAttribute(name = "gluuOrgProfileMgt")
	private GluuBoolean profileManagment;

	@LdapAttribute(name = "gluuWhitePagesEnabled")
	private GluuBoolean whitePagesEnabled;

	@LdapAttribute(name = "gluuFederationHostingEnabled")
	private GluuBoolean federationHostingEnabled;

	@LdapAttribute(name = "gluuManageIdentityPermission")
	private GluuBoolean manageIdentityPermission;

	@LdapAttribute(name = "gluuVdsCacheRefreshEnabled")
	private GluuBoolean vdsCacheRefreshEnabled;

	@LdapAttribute(name = "gluuVdsCacheRefreshPollingInterval")
	private String vdsCacheRefreshPollingInterval;

	@LdapAttribute(name = "gluuVdsCacheRefreshLastUpdate")
	private String vdsCacheRefreshLastUpdate;

	@LdapAttribute(name = "gluuVdsCacheRefreshLastUpdateCount")
	private String vdsCacheRefreshLastUpdateCount;

	@LdapAttribute(name = "gluuVdsCacheRefreshProblemCount")
	private String vdsCacheRefreshProblemCount;

	@LdapAttribute(name = "gluuScimEnabled")
	private GluuBoolean scimEnabled;

	@LdapAttribute(name = "gluuCentreonEmail")
	private String centreonEmail;

	@LdapAttribute(name = "gluuJiraEmail")
	private String jiraEmail;

	@LdapAttribute(name = "gluuBillingEmail")
	private String billingEmail;

	@LdapAttribute(name = "gluuPrivacyEmail")
	private String privacyEmail;

	@LdapAttribute(name = "gluuSvnEmail")
	private String svnEmail;

	@LdapAttribute(name = "gluuSmtpHost")
	private String smtpHost;

	@LdapAttribute(name = "gluuSmtpFromName")
	private String smtpFromName;

	@LdapAttribute(name = "gluuSmtpFromEmailAddress")
	private String smtpFromEmailAddress;

	@LdapAttribute(name = "gluuSmtpRequiresAuthentication")
	private String smtpRequiresAuthentication;

	@LdapAttribute(name = "gluuSmtpUserName")
	private String smtpUserName;

	@LdapAttribute(name = "gluuSmtpPassword")
	private String smtpPassword;

	@Transient
	private String smtpPasswordStr;

	@LdapAttribute(name = "gluuSmtpRequiresSsl")
	private String smtpRequiresSsl;

	@LdapAttribute(name = "gluuSmtpPort")
	private String smtpPort;

	@LdapAttribute(name = "gluuApplianceDnsServer")
	private String applianceDnsServer;

	@LdapAttribute(name = "gluuMaxLogSize")
	private String maxLogSize;

	@LdapAttribute(name = "gluuLoadAvg", updateOnly = true)
	private String loadAvg;

	@LdapAttribute(name = "oxIDPAuthentication")
	private List<String> oxIDPAuthentication;

	@LdapAttribute(name = "oxAuthenticationMode")
	private String authenticationMode;

	@LdapAttribute(name = "oxAuthenticationLevel")
	private String authenticationLevel;

	public String getInum() {
		return inum;
	}

	public void setInum(String inum) {
		this.inum = inum;
	}

	public String getInumFN() {
		return inumFN;
	}

	public void setInumFN(String inumFN) {
		this.inumFN = inumFN;
	}

	public String getIname() {
		return iname;
	}

	public void setIname(String iname) {
		this.iname = iname;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getDisplayName() {
		return displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public String getOwner() {
		return owner;
	}

	public void setOwner(String owner) {
		this.owner = owner;
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public String getFreeDiskSpace() {
		return freeDiskSpace;
	}

	public void setFreeDiskSpace(String freeDiskSpace) {
		this.freeDiskSpace = freeDiskSpace;
	}

	public String getFreeMemory() {
		return freeMemory;
	}

	public void setFreeMemory(String freeMemory) {
		this.freeMemory = freeMemory;
	}

	public String getFreeSwap() {
		return freeSwap;
	}

	public void setFreeSwap(String freeSwap) {
		this.freeSwap = freeSwap;
	}

	public String getGroupCount() {
		return groupCount;
	}

	public void setGroupCount(String groupCount) {
		this.groupCount = groupCount;
	}

	public String getHostname() {
		return hostname;
	}

	public void setHostname(String hostname) {
		this.hostname = hostname;
	}

	public String getIpAddress() {
		return ipAddress;
	}

	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	public String getPersonCount() {
		return personCount;
	}

	public void setPersonCount(String personCount) {
		this.personCount = personCount;
	}

	public String getShibAssertionsIssued() {
		return shibAssertionsIssued;
	}

	public void setShibAssertionsIssued(String shibAssertionsIssued) {
		this.shibAssertionsIssued = shibAssertionsIssued;
	}

	public String getShibFailedAuth() {
		return shibFailedAuth;
	}

	public void setShibFailedAuth(String shibFailedAuth) {
		this.shibFailedAuth = shibFailedAuth;
	}

	public String getShibSecurityEvents() {
		return shibSecurityEvents;
	}

	public void setShibSecurityEvents(String shibSecurityEvents) {
		this.shibSecurityEvents = shibSecurityEvents;
	}

	public String getShibSuccessfulAuths() {
		return shibSuccessfulAuths;
	}

	public void setShibSuccessfulAuths(String shibSuccessfulAuths) {
		this.shibSuccessfulAuths = shibSuccessfulAuths;
	}

	public String getSystemUptime() {
		return systemUptime;
	}

	public void setSystemUptime(String systemUptime) {
		this.systemUptime = systemUptime;
	}

	public String getLastUpdate() {
		return lastUpdate;
	}

	public Date getLastUpdateDate() {
		try {
			return (lastUpdate == null) ? null : new Date(Long.valueOf(lastUpdate) * 1000);
		} catch (NumberFormatException ex) {
		}

		return null;
	}

	public void setLastUpdate(String lastUpdate) {
		this.lastUpdate = lastUpdate;
	}

	public String getPollingInterval() {
		return pollingInterval;
	}

	public void setPollingInterval(String pollingInterval) {
		this.pollingInterval = pollingInterval;
	}

	public GluuStatus getStatus() {
		return status;
	}

	public void setStatus(GluuStatus status) {
		this.status = status;
	}

	public String getUserPassword() {
		return this.userPassword;
	}

	public void setUserPassword(String userPassword) {
		this.userPassword = userPassword;
	}

	public String getBlowfishPassword() {
		return this.blowfishPassword;
	}

	public void setBlowfishPassword(String blowfishPassword) {
		this.blowfishPassword = blowfishPassword;
	}

	public String getGluuHttpStatus() {
		return gluuHttpStatus;
	}

	public void setGluuHttpStatus(String gluuHttpStatus) {
		this.gluuHttpStatus = gluuHttpStatus;
	}

	public String getGluuDSStatus() {
		return gluuDSStatus;
	}

	public void setGluuDSStatus(String gluuDSStatus) {
		this.gluuDSStatus = gluuDSStatus;
	}

	public String getGluuVDSStatus() {
		return gluuVDSStatus;
	}

	public void setGluuVDSStatus(String gluuVDSStatus) {
		this.gluuVDSStatus = gluuVDSStatus;
	}

	public void setGluuBandwidthTX(String gluuBandwidthTX) {
		this.gluuBandwidthTX = gluuBandwidthTX;
	}

	public String getGluuBandwidthTX() {
		return gluuBandwidthTX;
	}

	public void setGluuBandwidthRX(String gluuBandwidthRX) {
		this.gluuBandwidthRX = gluuBandwidthRX;
	}

	public String getGluuBandwidthRX() {
		return gluuBandwidthRX;
	}

	public void setGluuSPTR(String gluuSPTR) {
		this.gluuSPTR = gluuSPTR;
	}

	public String getGluuSPTR() {
		return gluuSPTR;
	}

	public void setSslExpiry(String intString) {
		sslExpiry = intString;
	}

	public String getSslExpiry() {
		return sslExpiry;
	}

	public GluuBoolean getProfileManagment() {
		return profileManagment;
	}

	public void setProfileManagment(GluuBoolean profileManagment) {
		this.profileManagment = profileManagment;
	}

	public void setWhitePagesEnabled(GluuBoolean whitePagesEnabled) {
		this.whitePagesEnabled = whitePagesEnabled;
	}

	public GluuBoolean getWhitePagesEnabled() {
		return whitePagesEnabled;
	}

	public void setFederationHostingEnabled(GluuBoolean federationHostingEnabled) {
		this.federationHostingEnabled = federationHostingEnabled;
	}

	public GluuBoolean getFederationHostingEnabled() {
		return federationHostingEnabled;
	}

	public void setManageIdentityPermission(GluuBoolean manageIdentityPermission) {
		this.manageIdentityPermission = manageIdentityPermission;
	}

	public GluuBoolean getManageIdentityPermission() {
		return manageIdentityPermission;
	}

	public GluuBoolean getScimEnabled() {
		return scimEnabled;
	}

	public void setScimEnabled(GluuBoolean scimEnabled) {
		this.scimEnabled = scimEnabled;
	}

	public GluuBoolean getVdsCacheRefreshEnabled() {
		return vdsCacheRefreshEnabled;
	}

	public void setVdsCacheRefreshEnabled(GluuBoolean vdsCacheRefreshEnabled) {
		this.vdsCacheRefreshEnabled = vdsCacheRefreshEnabled;
	}

	public String getVdsCacheRefreshPollingInterval() {
		return vdsCacheRefreshPollingInterval;
	}

	public void setVdsCacheRefreshPollingInterval(String vdsCacheRefreshPollingInterval) {
		this.vdsCacheRefreshPollingInterval = vdsCacheRefreshPollingInterval;
	}

	public String getVdsCacheRefreshLastUpdate() {
		return vdsCacheRefreshLastUpdate;
	}

	public Date getVdsCacheRefreshLastUpdateDate() {
		try {
			return (vdsCacheRefreshLastUpdate == null) ? null : new Date(Long.valueOf(vdsCacheRefreshLastUpdate) * 1000);
		} catch (NumberFormatException ex) {
		}

		return null;
	}

	public void setVdsCacheRefreshLastUpdate(String vdsCacheRefreshLastUpdate) {
		this.vdsCacheRefreshLastUpdate = vdsCacheRefreshLastUpdate;
	}

	public String getVdsCacheRefreshLastUpdateCount() {
		return vdsCacheRefreshLastUpdateCount;
	}

	public void setVdsCacheRefreshLastUpdateCount(String vdsCacheRefreshLastUpdateCount) {
		this.vdsCacheRefreshLastUpdateCount = vdsCacheRefreshLastUpdateCount;
	}

	public String getVdsCacheRefreshProblemCount() {
		return vdsCacheRefreshProblemCount;
	}

	public void setVdsCacheRefreshProblemCount(String vdsCacheRefreshProblemCount) {
		this.vdsCacheRefreshProblemCount = vdsCacheRefreshProblemCount;
	}

	public String getCentreonEmail() {
		return centreonEmail;
	}

	public void setCentreonEmail(String centreonEmail) {
		this.centreonEmail = centreonEmail;
	}

	public String getJiraEmail() {
		return jiraEmail;
	}

	public void setJiraEmail(String jiraEmail) {
		this.jiraEmail = jiraEmail;
	}

	public String getBillingEmail() {
		return billingEmail;
	}

	public void setBillingEmail(String billingEmail) {
		this.billingEmail = billingEmail;
	}

	public String getPrivacyEmail() {
		return privacyEmail;
	}

	public void setPrivacyEmail(String privacyEmail) {
		this.privacyEmail = privacyEmail;
	}

	public String getSvnEmail() {
		return svnEmail;
	}

	public void setSvnEmail(String svnEmail) {
		this.svnEmail = svnEmail;
	}

	public String getSmtpHost() {
		return smtpHost;
	}

	public void setSmtpHost(String smtpHost) {
		this.smtpHost = smtpHost;
	}

	public String getSmtpFromName() {
		return smtpFromName;
	}

	public void setSmtpFromName(String smtpFromName) {
		this.smtpFromName = smtpFromName;
	}

	public String getSmtpFromEmailAddress() {
		return smtpFromEmailAddress;
	}

	public void setSmtpFromEmailAddress(String smtpFromEmailAddress) {
		this.smtpFromEmailAddress = smtpFromEmailAddress;
	}

	public String getSmtpRequiresAuthentication() {
		return smtpRequiresAuthentication;
	}

	public void setSmtpRequiresAuthentication(String smtpRequiresAuthentication) {
		this.smtpRequiresAuthentication = smtpRequiresAuthentication;
	}

	public boolean isRequiresAuthentication() {
		return Boolean.parseBoolean(smtpRequiresAuthentication);
	}

	public void setRequiresAuthentication(boolean requiresAuthentication) {
		this.smtpRequiresAuthentication = Boolean.toString(requiresAuthentication);
	}

	public String getSmtpUserName() {
		return smtpUserName;
	}

	public void setSmtpUserName(String smtpUserName) {
		this.smtpUserName = smtpUserName;
	}

	public String getSmtpPassword() {
		return smtpPassword;
	}

	public void setSmtpPassword(String smtpPassword) {
		if (smtpPassword != null && !smtpPassword.equals("")) {
			this.smtpPassword = smtpPassword;
			smtpPasswordStr = smtpPassword;
			try {
				smtpPasswordStr = StringEncrypter.defaultInstance().decrypt(smtpPasswordStr);
			} catch (Exception ex) {
				log.error("Failed to decrypt password: " + smtpPassword, ex);
			}
		}
	}

	public String getSmtpPasswordStr() {
		return smtpPasswordStr;
	}

	public void setSmtpPasswordStr(String smtpPasswordStr) {
		if (smtpPasswordStr != null && !smtpPasswordStr.equals("")) {
			this.smtpPasswordStr = smtpPasswordStr;
			smtpPassword = smtpPasswordStr;
			try {
				smtpPassword = StringEncrypter.defaultInstance().encrypt(smtpPassword);
			} catch (Exception ex) {
				log.error("Failed to encrypt password: " + smtpPassword, ex);
			}
		}
	}

	public String getSmtpRequiresSsl() {
		return smtpRequiresSsl;
	}

	public void setSmtpRequiresSsl(String smtpRequiresSsl) {
		this.smtpRequiresSsl = smtpRequiresSsl;
	}

	public boolean isRequiresSsl() {
		return Boolean.parseBoolean(smtpRequiresSsl);
	}

	public void setRequiresSsl(boolean requiresSsl) {
		this.smtpRequiresSsl = Boolean.toString(requiresSsl);
	}

	public String getSmtpPort() {
		return smtpPort;
	}

	public void setSmtpPort(String smtpPort) {
		this.smtpPort = smtpPort;
	}

	public String getApplianceDnsServer() {
		return applianceDnsServer;
	}

	public void setApplianceDnsServer(String applianceDnsServer) {
		this.applianceDnsServer = applianceDnsServer;
	}

	@Min(value = 200)
	public String getMaxLogSize() {
		return maxLogSize;
	}

	public void setMaxLogSize(String maxLogSize) {
		this.maxLogSize = maxLogSize;
	}

	/**
	 * @return the loadAvg
	 */
	public String getLoadAvg() {
		return loadAvg;
	}

	/**
	 * @param loadAvg
	 *            the loadAvg to set
	 */
	public void setLoadAvg(String loadAvg) {
		this.loadAvg = loadAvg;
	}

	public List<String> getOxIDPAuthentication() {
		return this.oxIDPAuthentication;
	}

	public void setOxIDPAuthentication(List<String> oxIDPAuthentication) {
		this.oxIDPAuthentication = oxIDPAuthentication;
	}

	// @Override
	// public String toString() {
	// return String
	// .format("GluuAppliance [inum=%s, inumFN=%s, iname=%s, description=%s, displayName=%s, owner=%s, country=%s, freeDiskSpace=%s, freeMemory=%s, freeSwap=%s, groupCount=%s, hostname=%s, ipAddress=%s, personCount=%s, shibAssertionsIssued=%s, shibFailedAuth=%s, shibSecurityEvents=%s, shibSuccessfulAuths=%s, systemUptime=%s, lastUpdate=%s, pollingInterval=%s, status=%s, userPassword=%s, blowfishPassword=%s, gluuHttpStatus=%s, gluuDSStatus=%s, gluuVDSStatus=%s, gluuBandwidthTX=%s, gluuBandwidthRX=%s, gluuSPTR=%s, sslExpiry=%s, profileManagment=%s, whitePagesEnabled=%s, federationHostingEnabled=%s, manageIdentityPermission=%s, vdsCacheRefreshEnabled=%s, vdsCacheRefreshPollingInterval=%s, vdsCacheRefreshLastUpdate=%s, vdsCacheRefreshLastUpdateCount=%s, vdsCacheRefreshProblemCount=%s, scimEnabled=%s, centreonEmail=%s, jiraEmail=%s, billingEmail=%s, privacyEmail=%s, svnEmail=%s, smtpHost=%s, smtpFromName=%s, smtpFromEmailAddress=%s, smtpRequiresAuthentication=%s, smtpUserName=%s, smtpPassword=%s, smtpPasswordStr=%s, smtpRequiresSsl=%s, smtpPort=%s, applianceDnsServer=%s, maxLogSize=%s, loadAvg=%s, oxIDPAuthentication=%s, toString()=%s]",
	// inum, inumFN, iname, description, displayName, owner, country,
	// freeDiskSpace, freeMemory, freeSwap, groupCount,
	// hostname, ipAddress, personCount, shibAssertionsIssued, shibFailedAuth,
	// shibSecurityEvents, shibSuccessfulAuths,
	// systemUptime, lastUpdate, pollingInterval, status, userPassword,
	// blowfishPassword, gluuHttpStatus, gluuDSStatus,
	// gluuVDSStatus, gluuBandwidthTX, gluuBandwidthRX, gluuSPTR, sslExpiry,
	// profileManagment, whitePagesEnabled,
	// federationHostingEnabled, manageIdentityPermission,
	// vdsCacheRefreshEnabled, vdsCacheRefreshPollingInterval,
	// vdsCacheRefreshLastUpdate, vdsCacheRefreshLastUpdateCount,
	// vdsCacheRefreshProblemCount, centreonEmail,
	// jiraEmail, billingEmail, privacyEmail, svnEmail, smtpHost, smtpFromName,
	// smtpFromEmailAddress,
	// smtpRequiresAuthentication, smtpUserName, smtpPassword, smtpPasswordStr,
	// smtpRequiresSsl, smtpPort,
	// applianceDnsServer, maxLogSize, loadAvg, oxIDPAuthentication,
	// super.toString());
	// }

	public String getAuthenticationMode() {
		return authenticationMode;
	}

	public void setAuthenticationMode(String authenticationMode) {
		this.authenticationMode = authenticationMode;
	}

	public String getAuthenticationLevel() {
		return authenticationLevel;
	}

	public void setAuthenticationLevel(String authenticationLevel) {
		this.authenticationLevel = authenticationLevel;
	}

	@Override
	public String toString() {
		final StringBuilder sb = new StringBuilder();
		sb.append("GluuAppliance");
		sb.append("{applianceDnsServer='").append(applianceDnsServer).append('\'');
		sb.append(", inum='").append(inum).append('\'');
		sb.append(", inumFN='").append(inumFN).append('\'');
		sb.append(", iname='").append(iname).append('\'');
		sb.append(", description='").append(description).append('\'');
		sb.append(", displayName='").append(displayName).append('\'');
		sb.append(", owner='").append(owner).append('\'');
		sb.append(", country='").append(country).append('\'');
		sb.append(", freeDiskSpace='").append(freeDiskSpace).append('\'');
		sb.append(", freeMemory='").append(freeMemory).append('\'');
		sb.append(", freeSwap='").append(freeSwap).append('\'');
		sb.append(", groupCount='").append(groupCount).append('\'');
		sb.append(", hostname='").append(hostname).append('\'');
		sb.append(", ipAddress='").append(ipAddress).append('\'');
		sb.append(", personCount='").append(personCount).append('\'');
		sb.append(", shibAssertionsIssued='").append(shibAssertionsIssued).append('\'');
		sb.append(", shibFailedAuth='").append(shibFailedAuth).append('\'');
		sb.append(", shibSecurityEvents='").append(shibSecurityEvents).append('\'');
		sb.append(", shibSuccessfulAuths='").append(shibSuccessfulAuths).append('\'');
		sb.append(", systemUptime='").append(systemUptime).append('\'');
		sb.append(", lastUpdate='").append(lastUpdate).append('\'');
		sb.append(", pollingInterval='").append(pollingInterval).append('\'');
		sb.append(", status=").append(status);
		sb.append(", userPassword='").append(userPassword).append('\'');
		sb.append(", blowfishPassword='").append(blowfishPassword).append('\'');
		sb.append(", gluuHttpStatus='").append(gluuHttpStatus).append('\'');
		sb.append(", gluuDSStatus='").append(gluuDSStatus).append('\'');
		sb.append(", gluuVDSStatus='").append(gluuVDSStatus).append('\'');
		sb.append(", gluuBandwidthTX='").append(gluuBandwidthTX).append('\'');
		sb.append(", gluuBandwidthRX='").append(gluuBandwidthRX).append('\'');
		sb.append(", gluuSPTR='").append(gluuSPTR).append('\'');
		sb.append(", sslExpiry='").append(sslExpiry).append('\'');
		sb.append(", profileManagment=").append(profileManagment);
		sb.append(", whitePagesEnabled=").append(whitePagesEnabled);
		sb.append(", federationHostingEnabled=").append(federationHostingEnabled);
		sb.append(", manageIdentityPermission=").append(manageIdentityPermission);
		sb.append(", vdsCacheRefreshEnabled=").append(vdsCacheRefreshEnabled);
		sb.append(", vdsCacheRefreshPollingInterval='").append(vdsCacheRefreshPollingInterval).append('\'');
		sb.append(", vdsCacheRefreshLastUpdate='").append(vdsCacheRefreshLastUpdate).append('\'');
		sb.append(", vdsCacheRefreshLastUpdateCount='").append(vdsCacheRefreshLastUpdateCount).append('\'');
		sb.append(", vdsCacheRefreshProblemCount='").append(vdsCacheRefreshProblemCount).append('\'');
		sb.append(", scimEnabled=").append(scimEnabled);
		sb.append(", centreonEmail='").append(centreonEmail).append('\'');
		sb.append(", jiraEmail='").append(jiraEmail).append('\'');
		sb.append(", billingEmail='").append(billingEmail).append('\'');
		sb.append(", privacyEmail='").append(privacyEmail).append('\'');
		sb.append(", svnEmail='").append(svnEmail).append('\'');
		sb.append(", smtpHost='").append(smtpHost).append('\'');
		sb.append(", smtpFromName='").append(smtpFromName).append('\'');
		sb.append(", smtpFromEmailAddress='").append(smtpFromEmailAddress).append('\'');
		sb.append(", smtpRequiresAuthentication='").append(smtpRequiresAuthentication).append('\'');
		sb.append(", smtpUserName='").append(smtpUserName).append('\'');
		sb.append(", smtpPassword='").append(smtpPassword).append('\'');
		sb.append(", smtpPasswordStr='").append(smtpPasswordStr).append('\'');
		sb.append(", smtpRequiresSsl='").append(smtpRequiresSsl).append('\'');
		sb.append(", smtpPort='").append(smtpPort).append('\'');
		sb.append(", maxLogSize='").append(maxLogSize).append('\'');
		sb.append(", loadAvg='").append(loadAvg).append('\'');
		sb.append(", oxIDPAuthentication=").append(oxIDPAuthentication);
		sb.append(", authenticationMode=").append(authenticationMode);
		sb.append(", authenticationLevel=").append(authenticationLevel);
		sb.append('}');
		return sb.toString();
	}
}
