package org.gluu.oxtrust.model.uma;

import java.util.List;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.ldap.model.InumEntry;

/**
 * UMA resource set LDAP model
 * 
 * @author Yuriy Movchan Date: 10/03/2012
 */
@LdapEntry(sortBy = { "displayName" })
@LdapObjectClass(values = { "top", "oxAuthUmaResourceSet" })
public class ResourceSet extends InumEntry {

	@Size(min = 4, max = 30, message = "Length of resource set name should be between 4 and 30")
	@Pattern(regexp = "^[a-zA-Z\\d_]{4,30}$", message = "Invalid resource set name ")
	@LdapAttribute(name = "oxId")
	private String id;

	@LdapAttribute(name = "oxFaviconImage")
	private String icon;

	@NotNull(message = "Display name should be not empty")
	@LdapAttribute
	private String displayName;

	@LdapAttribute(name = "oxAuthUmaScope")
	private List<String> associatedScopes;

	@LdapAttribute(name = "oxGroup")
	private List<String> associatedGroups;

	@LdapAttribute(name = "oxResource")
	private List<String> resources;

	@LdapAttribute(name = "oxRevision")
	private String rev;

	@LdapAttribute
	private String owner;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getIcon() {
		return icon;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	public String getDisplayName() {
		return displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public List<String> getAssociatedScopes() {
		return associatedScopes;
	}

	public void setAssociatedScopes(List<String> associatedScopes) {
		this.associatedScopes = associatedScopes;
	}

	public List<String> getAssociatedGroups() {
		return associatedGroups;
	}

	public void setAssociatedGroups(List<String> associatedGroups) {
		this.associatedGroups = associatedGroups;
	}

	public List<String> getResources() {
		return resources;
	}

	public void setResources(List<String> resources) {
		this.resources = resources;
	}

	public String getRev() {
		return rev;
	}

	public void setRev(String rev) {
		this.rev = rev;
	}

	public String getOwner() {
		return owner;
	}

	public void setOwner(String owner) {
		this.owner = owner;
	}

}
