package org.gluu.oxtrust.model.uma;

import java.util.Date;

import javax.validation.constraints.NotNull;

import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.ldap.model.InumEntry;

/**
 * UMA Host client
 * 
 * @author Yuriy Movchan Date: 10/03/2012
 */
@LdapEntry(sortBy = { "displayName" })
@LdapObjectClass(values = { "top", "oxAuthUmaHostClient" })
public class HostClient extends InumEntry {

	@NotNull(message = "Issuer should be not empty")
	@LdapAttribute(name = "oxId")
	private String id;

	@NotNull(message = "Display name should be not empty")
	@LdapAttribute
	private String displayName;

	@LdapAttribute(name = "oxAuthClientId")
	private String clientId;

	@LdapAttribute(name = "oxAuthClientSecret")
	private String encodedClientSecret;

	@LdapAttribute(name = "registrationDate")
	private Date registrationDate;

	@LdapAttribute(name = "oxRevision")
	private String rev;

	@LdapAttribute
	private String owner;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getDisplayName() {
		return displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public String getClientId() {
		return clientId;
	}

	public void setClientId(String clientId) {
		this.clientId = clientId;
	}

	public String getEncodedClientSecret() {
		return encodedClientSecret;
	}

	public void setEncodedClientSecret(String encodedClientSecret) {
		this.encodedClientSecret = encodedClientSecret;
	}

	public Date getRegistrationDate() {
		return registrationDate;
	}

	public void setRegistrationDate(Date registrationDate) {
		this.registrationDate = registrationDate;
	}

	public String getRev() {
		return rev;
	}

	public void setRev(String rev) {
		this.rev = rev;
	}

	public String getOwner() {
		return owner;
	}

	public void setOwner(String owner) {
		this.owner = owner;
	}

}
