package org.gluu.oxtrust.model;

import java.io.Serializable;
import java.util.List;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.ldap.model.Entry;
import org.xdi.util.security.StringEncrypter;
import org.xdi.util.security.StringEncrypter.EncryptionException;

/**
 * oxAuthClient
 * 
 * @author Reda Zerrad Date: 06.08.2012
 */
@LdapEntry(sortBy = { "displayName" })
@LdapObjectClass(values = { "top", "oxAuthClient"})
public class OxAuthClient extends Entry implements Serializable {

	/**
     *
     */
	private static final long serialVersionUID = -2310140703735705346L;

	@LdapAttribute(ignoreDuringUpdate = true)
	private String inum;

	@LdapAttribute(ignoreDuringUpdate = true)
	private String iname;

	@NotNull
	@Size(min = 0, max = 60, message = "Length of the Display Name should not exceed 60")
	@LdapAttribute
	private String displayName;

	@NotNull
	@LdapAttribute(name = "oxAuthAppType")
	private OxAuthApplicationType oxAuthAppType;

	@LdapAttribute(name = "oxAuthRedirectURI")
	private List<String> oxAuthRedirectURIs;

	@LdapAttribute(name = "oxAuthScope")
	private List<String> oxAuthScopes;

	@NotNull
	@LdapAttribute(name = "oxAuthClientSecret")
	private String encodedClientSecret;

	@LdapAttribute(ignoreDuringUpdate = true)
	private String userPassword;

	@LdapAttribute(name = "oxAuthIdTokenSignedResponseAlg")
	private TokenResponseAlgs oxAuthIdTokenSignedResponseAlg;

	@LdapAttribute(name = "associatedPerson")
	private List<String> associatedPersons;

	@LdapAttribute(name = "oxAuthTrustedClient")
	private OxAuthTrustedClientBox oxAuthTrustedClient;

	@LdapAttribute(name = "oxAuthClientUserGroup")
	private List<String> oxAuthClientUserGroups;

	private String oxAuthClientSecret;

	public String getInum() {
		return this.inum;
	}

	public void setInum(String inum) {
		this.inum = inum;
	}

	public String getIname() {
		return this.iname;
	}

	public void setIname(String iname) {
		this.iname = iname;
	}

	public String getDisplayName() {
		return this.displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public OxAuthApplicationType getOxAuthAppType() {
		return this.oxAuthAppType;
	}

	public void setOxAuthAppType(OxAuthApplicationType oxAuthAppType) {
		this.oxAuthAppType = oxAuthAppType;
	}

	public OxAuthTrustedClientBox getOxAuthTrustedClient() {
		return this.oxAuthTrustedClient;
	}

	public void setOxAuthTrustedClient(OxAuthTrustedClientBox oxAuthTrustedClient) {
		this.oxAuthTrustedClient = oxAuthTrustedClient;
	}

	public List<String> getOxAuthRedirectURIs() {
		return this.oxAuthRedirectURIs;
	}

	public void setOxAuthRedirectURIs(List<String> oxAuthRedirectURIs) {
		this.oxAuthRedirectURIs = oxAuthRedirectURIs;
	}

	public List<String> getOxAuthScopes() {
		return this.oxAuthScopes;
	}

	public void setOxAuthScopes(List<String> oxAuthScopes) {
		this.oxAuthScopes = oxAuthScopes;
	}

	public String getOxAuthClientSecret() throws EncryptionException {
		/*
		 * if(this.encodedClientSecret != null &&
		 * this.encodedClientSecret.length()>1){ this.oxAuthClientSecret =
		 * StringEncrypter.defaultInstance().decrypt(this.encodedClientSecret);
		 * }
		 */
		return this.oxAuthClientSecret;
	}

	public void setOxAuthClientSecret(String oxAuthClientSecret) throws EncryptionException {
		this.oxAuthClientSecret = oxAuthClientSecret;
		if (oxAuthClientSecret != null && oxAuthClientSecret.length() > 1) {
			setEncodedClientSecret(StringEncrypter.defaultInstance().encrypt(oxAuthClientSecret));
		}
	}

	public String getUserPassword() {
		return this.userPassword;
	}

	public void setUserPassword(String userPassword) {
		this.userPassword = userPassword;
	}

	public TokenResponseAlgs getOxAuthIdTokenSignedResponseAlg() {

		return this.oxAuthIdTokenSignedResponseAlg;
	}

	public void setOxAuthIdTokenSignedResponseAlg(TokenResponseAlgs oxAuthIdTokenSignedResponseAlg) {

		this.oxAuthIdTokenSignedResponseAlg = oxAuthIdTokenSignedResponseAlg;
	}

	public List<String> getAssociatedPersons() {
		return this.associatedPersons;
	}

	public void setAssociatedPersons(List<String> associatedPersons) {
		this.associatedPersons = associatedPersons;
	}

	public String getEncodedClientSecret() {
		return this.encodedClientSecret;
	}

	public void setEncodedClientSecret(String encodedClientSecret) {
		this.encodedClientSecret = encodedClientSecret;
	}

	public List<String> getOxAuthClientUserGroups() {
		return this.oxAuthClientUserGroups;
	}

	public void setOxAuthClientUserGroups(List<String> oxAuthClientUserGroups) {
		this.oxAuthClientUserGroups = oxAuthClientUserGroups;
	}

	@Override
	public String toString() {
		return String
				.format("oxAuthClient [ displayName=%s, iname=%s, inum=%s, oxAuthAppType=%s, oxAuthRedirectURIs=%s, oxAuthScopes=%s, oxAuthClientSecret=%s, userPassword=%s, associatedPerson=%s, oxAuthTrustedClient=%s, oxAuthClientUserGroup=%s, toString()=%s]",
						displayName, iname, inum, oxAuthAppType, oxAuthRedirectURIs, oxAuthScopes, encodedClientSecret, userPassword,
						associatedPersons, oxAuthTrustedClient, oxAuthClientUserGroups, super.toString());
	}

}
