package org.gluu.oxtrust.ws.rs;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gluu.oxtrust.model.scim.ScimGroup;
import org.gluu.oxtrust.util.Configuration;

/**
 * User: Dejan Maric
 */
@Path("/Groups")
public interface GroupWebService {

	@GET
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response listGroups(@Context HttpServletRequest request,
			@QueryParam(Configuration.QUERY_PARAMETER_FILTER) final String filterString,
			@QueryParam(Configuration.QUERY_PARAMETER_SORT_BY) final String sortBy,
			@QueryParam(Configuration.QUERY_PARAMETER_SORT_ORDER) final String sortOrder) throws Exception;

	@Path("{id}")
	@GET
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response getGroupById(@Context HttpServletRequest request, @PathParam("id") String id) throws Exception;

	@POST
	@Consumes({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response createGroup(@Context HttpServletRequest request, ScimGroup group) throws Exception;

	@Path("{id}")
	@PUT
	@Consumes({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response updateGroup(@Context HttpServletRequest request, @PathParam("id") String id, ScimGroup group) throws Exception;

	@Path("{id}")
	@DELETE
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response deleteGroup(@Context HttpServletRequest request, @PathParam("id") String id) throws Exception;

}
