package org.gluu.oxtrust.model;

import java.util.Date;

import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

/**
 * Hold Image specific information
 * 
 * @author Yuriy Movchan Date: 11.03.2010
 */
@XmlRootElement
public class GluuImage implements java.io.Serializable {

	private static final long serialVersionUID = -1003707352122915106L;

	private String uuid;

	private String creator;

	private String sourceName;

	private String sourceFilePath;

	private Date creationDate;

	private String sourceContentType;

	private long size;

	private int width;

	private int height;

	private String thumbFilePath;

	private String thumbContentType;

	private int thumbWidth;

	private int thumbHeight;

	private byte[] data;

	private boolean storeTemporary;

	private boolean isLogo;

	@Transient
	@XmlTransient
	public boolean isLandscape() {
		return width > height;
	}

	public String getUuid() {
		return uuid;
	}

	public void setUuid(String uuid) {
		this.uuid = uuid;
	}

	public String getCreator() {
		return creator;
	}

	public void setCreator(String creator) {
		this.creator = creator;
	}

	public String getSourceName() {
		return sourceName;
	}

	public void setSourceName(String sourceName) {
		this.sourceName = sourceName;
	}

	public String getSourceFilePath() {
		return sourceFilePath;
	}

	public void setSourceFilePath(String sourceFilePath) {
		this.sourceFilePath = sourceFilePath;
	}

	public Date getCreationDate() {
		return creationDate != null ? new Date(creationDate.getTime()) : null;
	}

	public void setCreationDate(Date creationDate) {
		this.creationDate = creationDate != null ? new Date(creationDate.getTime()) : null;
	}

	public String getSourceContentType() {
		return sourceContentType;
	}

	public void setSourceContentType(String sourceContentType) {
		this.sourceContentType = sourceContentType;
	}

	public long getSize() {
		return size;
	}

	public void setSize(long size) {
		this.size = size;
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	public int getHeight() {
		return height;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	public String getThumbFilePath() {
		return thumbFilePath;
	}

	public void setThumbFilePath(String thumbFilePath) {
		this.thumbFilePath = thumbFilePath;
	}

	public String getThumbContentType() {
		return thumbContentType;
	}

	public void setThumbContentType(String thumbContentType) {
		this.thumbContentType = thumbContentType;
	}

	public int getThumbWidth() {
		return thumbWidth;
	}

	public void setThumbWidth(int thumbWidth) {
		this.thumbWidth = thumbWidth;
	}

	public int getThumbHeight() {
		return thumbHeight;
	}

	public void setThumbHeight(int thumbHeight) {
		this.thumbHeight = thumbHeight;
	}

	public void setStoreTemporary(boolean storeTemporary) {
		this.storeTemporary = storeTemporary;
	}

	@Transient
	@XmlTransient
	public boolean isStoreTemporary() {
		return storeTemporary;
	}

	public void setLogo(boolean isLogo) {
		this.isLogo = isLogo;
	}

	@Transient
	@XmlTransient
	public boolean isLogo() {
		return isLogo;
	}

	public void setData(byte[] data) {
		this.data = data;
	}

	@Transient
	@XmlTransient
	public byte[] getData() {
		return data;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((uuid == null) ? 0 : uuid.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		GluuImage other = (GluuImage) obj;
		if (uuid == null) {
			if (other.uuid != null) {
				return false;
			}
		} else if (!uuid.equals(other.uuid)) {
			return false;
		}
		return true;
	}

	@Override
	public String toString() {
		return String
				.format("GluuImage [creationDate=%s, creator=%s, height=%s, size=%s, sourceContentType=%s, sourceFilePath=%s, sourceName=%s, thumbContentType=%s, thumbFilePath=%s, thumbHeight=%s, thumbWidth=%s, uuid=%s, width=%s]",
						creationDate, creator, height, size, sourceContentType, sourceFilePath, sourceName, thumbContentType,
						thumbFilePath, thumbHeight, thumbWidth, uuid, width);
	}

}
