package org.gluu.oxtrust.ldap.service.uma;

import java.util.List;

import org.gluu.oxtrust.ldap.service.HostService;
import org.gluu.oxtrust.model.uma.HostClient;
import org.gluu.oxtrust.model.uma.HostToken;
import org.gluu.oxtrust.model.uma.ResourceSet;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;

/**
 * @author Yuriy Movchan
 * @version 0.1, 12/08/2012
 */
@Name("resourceSetUmaSyncService")
@Scope(ScopeType.STATELESS)
@AutoCreate
public class ResourceSetUmaSyncService {

	@Logger
	private Log log;

	@In
	private HostTokenService hostTokenService;

	@In
	private HostService hostService;

	@In
	private HostClientService hostClientService;

	@In
	private ClientUmaWebService clientUmaWebService;

	public boolean syncResourceSet(String hostInum, ResourceSet resourceSet, boolean update) {
		String hostDn = hostService.getDnForHost(hostInum);

		List<HostClient> hostClients = hostClientService.getAllHostClients(hostDn, new String[] { "inum", "oxId" });

		boolean result = true;
		for (HostClient hostClient : hostClients) {
			try {
				HostToken hostToken = hostTokenService.getHostToken(hostInum, hostClient.getInum());
				if (hostToken == null) {
					return false;
				}

				if (update) {
					result &= clientUmaWebService.updateUmaResourceSet(hostToken, resourceSet);
				} else {
					result &= clientUmaWebService.addUmaResourceSet(hostToken, resourceSet);
				}
			} catch (Exception ex) {
				log.error("Failed to update resource set '{0}' at UMA AM '{1}'", ex, resourceSet.getInum(), hostClient.getId());
				result = false;
			}
		}

		return result;
	}

}