package org.gluu.oxtrust.ldap.cache.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.Transient;

import org.xdi.model.SimpleProperty;

/**
 * GluuLdapConfiguration
 * 
 * @author Yuriy Movchan Date: 07.29.2011
 */
public class GluuLdapConfiguration implements Serializable {

	private static final long serialVersionUID = -7160480457430436511L;

	private String configId;
	private String bindDN;
	private String bindPassword;
	private List<SimpleProperty> servers;
	private int maxConnections;
	private boolean useSSL;
	private List<SimpleProperty> baseDNs;
	private boolean useAnonymousBind;

	public GluuLdapConfiguration() {
		this.servers = new ArrayList<SimpleProperty>();
		this.baseDNs = new ArrayList<SimpleProperty>();
	}

	public GluuLdapConfiguration(String configId, String bindDN, String bindPassword, List<SimpleProperty> servers, int maxConnections,
			boolean useSSL, List<SimpleProperty> baseDNs, boolean useAnonymousBind) {
		this.configId = configId;
		this.bindDN = bindDN;
		this.bindPassword = bindPassword;
		this.servers = servers;
		this.maxConnections = maxConnections;
		this.useSSL = useSSL;
		this.baseDNs = baseDNs;
		this.useAnonymousBind = useAnonymousBind;
	}

	public String getConfigId() {
		return configId;
	}

	public void setConfigId(String configId) {
		this.configId = configId;
	}

	public String getBindDN() {
		return bindDN;
	}

	public void setBindDN(String bindDN) {
		this.bindDN = bindDN;
	}

	public String getBindPassword() {
		return bindPassword;
	}

	public void setBindPassword(String bindPassword) {
		this.bindPassword = bindPassword;
	}

	public List<SimpleProperty> getServers() {
		return servers;
	}

	public void setServers(List<SimpleProperty> servers) {
		this.servers = servers;
	}

	public int getMaxConnections() {
		return maxConnections;
	}

	public void setMaxConnections(int maxConnections) {
		this.maxConnections = maxConnections;
	}

	public boolean isUseSSL() {
		return useSSL;
	}

	public void setUseSSL(boolean useSSL) {
		this.useSSL = useSSL;
	}

	public List<SimpleProperty> getBaseDNs() {
		return baseDNs;
	}

	public void setBaseDNs(List<SimpleProperty> baseDNs) {
		this.baseDNs = baseDNs;
	}

	public boolean isUseAnonymousBind() {
		return useAnonymousBind;
	}

	public void setUseAnonymousBind(boolean useAnonymousBind) {
		this.useAnonymousBind = useAnonymousBind;
	}

	@Override
	public String toString() {
		return "GluuLdapConfiguration [configId=" + configId + ", bindDN=" + bindDN + ", bindPassword=" + bindPassword
				+ ", servers=" + servers + ", maxConnections=" + maxConnections + ", useSSL="
				+ useSSL + ", baseDNs=" + baseDNs + "useAnonymousBind" + useAnonymousBind + "]";
	}

}
