package org.gluu.oxtrust.action;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.codehaus.jackson.map.ObjectMapper;
import org.gluu.oxtrust.ldap.service.ApplianceService;
import org.gluu.oxtrust.model.GluuAppliance;
import org.gluu.oxtrust.model.LdapConfig;
import org.gluu.oxtrust.model.OxIDPAuthConf;
import org.gluu.oxtrust.model.scim.ScimCustomAttributes;
import org.gluu.oxtrust.util.Configuration;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.security.Restrict;

@Name("ldapBindPasswordAction")
@Scope(ScopeType.EVENT)
@Restrict("#{identity.loggedIn}")
public class LdapBindPasswordAction implements Serializable {

	private static final long serialVersionUID = 6486111971437252913L;

	private String newPassword;
	private String newPasswordConfirmation;
	private String passwordMessage;

	@In
	private transient ApplianceService applianceService;

	// @Logger
	// private Log log;

	public String validatePassword() {
		String result;
		if (newPasswordConfirmation == null || !newPasswordConfirmation.equals(newPassword)) {
			this.passwordMessage = "Passwords Must be equal";
			result = Configuration.RESULT_VALIDATION_ERROR;
		} else {
			this.passwordMessage = "";
			result = Configuration.RESULT_SUCCESS;
		}

		return result;

	}

	@Restrict("#{s:hasPermission('profile', 'access')}")
	public String update() throws Exception {
		String result;
		if (true /* validatePassword().equals(Configuration.RESULT_SUCCESS) */) {
			GluuAppliance appliance = applianceService.getAppliance();

			List<OxIDPAuthConf> idpConfs = new ArrayList<OxIDPAuthConf>();

			for (String oneConf : appliance.getOxIDPAuthentication()) {
				OxIDPAuthConf aConf = null;

				try {
					aConf = (OxIDPAuthConf) jsonToObject(oneConf, OxIDPAuthConf.class);
				} catch (Exception e) {
					e.printStackTrace();
				}
				idpConfs.add(aConf);
			}

			LdapConfig ldapConfig = new LdapConfig();
			for (OxIDPAuthConf oneConf : idpConfs) {
				if (oneConf.getType().equalsIgnoreCase("ldap")) {
					ldapConfig = mapLdapConfig(oneConf);
				}
			}
			ldapConfig.setDecodedBindPw(newPassword);

			//

			List<OxIDPAuthConf> cleanIdpConfs = new ArrayList<OxIDPAuthConf>();

			if (!idpConfs.isEmpty()) {
				for (OxIDPAuthConf aConf : idpConfs) {
					if (aConf != null && !aConf.getType().equalsIgnoreCase("ldap")) {
						cleanIdpConfs.add(aConf);
					}
				}
			}

			cleanIdpConfs.add(ldapToIdp(ldapConfig));

			List<String> idpAuthStrings = new ArrayList<String>();
			for (OxIDPAuthConf oneConf : cleanIdpConfs) {
				String oneString = getJSONString(oneConf);
				idpAuthStrings.add(oneString);
			}

			appliance.setOxIDPAuthentication(idpAuthStrings);

			applianceService.updateAppliance(appliance);
			result = Configuration.RESULT_SUCCESS;
		} else {
			result = Configuration.RESULT_FAILURE;
		}
		return result;
	}

	public void cancel() {
	}

	public void setNewPasswordConfirmation(String newPasswordConfirmation) {
		this.newPasswordConfirmation = newPasswordConfirmation;
	}

	public String getNewPasswordConfirmation() {
		return newPasswordConfirmation;
	}

	public void setNewPassword(String newPassword) {
		this.newPassword = newPassword;
	}

	public String getNewPassword() {
		return newPassword;
	}

	public void setPasswordMessage(String passwordMessage) {
		this.passwordMessage = passwordMessage;
	}

	public String getPasswordMessage() {
		return passwordMessage;
	}

	private Object jsonToObject(String json, Class<?> clazz) throws Exception {
		ObjectMapper mapper = new ObjectMapper();
		return mapper.readValue(json, clazz);
	}

	private LdapConfig mapLdapConfig(OxIDPAuthConf oneConf) {
		LdapConfig ldapConfig = new LdapConfig();

		ldapConfig.setLdapHost(oneConf.getFields().get(0).getValues().get(0));
		ldapConfig.setLdapPort(oneConf.getFields().get(1).getValues().get(0));
		ldapConfig.setLdapBindDn(oneConf.getFields().get(2).getValues().get(0));
		ldapConfig.setLdapBindPw(oneConf.getFields().get(3).getValues().get(0));
		ldapConfig.setLdapUseSSL(Boolean.valueOf(oneConf.getFields().get(4).getValues().get(0)));
		ldapConfig.setLdapEnabled(oneConf.getEnabled());
		ldapConfig.setPriority(oneConf.getPriority());
		return ldapConfig;

	}

	private OxIDPAuthConf ldapToIdp(LdapConfig ldapConfig) {
		OxIDPAuthConf oxIDP = new OxIDPAuthConf();
		oxIDP.setEnabled(Boolean.valueOf(ldapConfig.getLdapEnabled()));
		oxIDP.setType("ldap");
		oxIDP.setPriority(Integer.valueOf(ldapConfig.getPriority()));
		List<ScimCustomAttributes> fields = new ArrayList<ScimCustomAttributes>();
		ScimCustomAttributes oneField = new ScimCustomAttributes();
		// ldapHost
		oneField.setName("ldapHost");
		oneField.getValues().add(ldapConfig.getLdapHost());
		fields.add(oneField);
		// ldapPort
		oneField = new ScimCustomAttributes();
		oneField.setName("ldapPort");
		oneField.getValues().add(ldapConfig.getLdapPort());
		fields.add(oneField);
		// ldapBindDn
		oneField = new ScimCustomAttributes();
		oneField.setName("ldapBindDn");
		oneField.getValues().add(ldapConfig.getLdapBindDn());
		fields.add(oneField);
		// ldapBindPw
		oneField = new ScimCustomAttributes();
		oneField.setName("ldapBindPw");
		oneField.getValues().add(ldapConfig.getLdapBindPw());
		fields.add(oneField);
		// ldapUseSSL
		oneField = new ScimCustomAttributes();
		oneField.setName("ldapUseSSL");
		oneField.getValues().add(Boolean.toString(ldapConfig.isLdapUseSSL()));
		fields.add(oneField);
		oxIDP.setFields(fields);
		return oxIDP;

	}

	private String getJSONString(Object ob) throws IOException {
		StringWriter sw = new StringWriter();
		ObjectMapper mapper = new ObjectMapper();
		mapper.writeValue(sw, ob);
		return sw.toString();
	}
}
