package org.gluu.oxtrust.ws.rs;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.gluu.oxtrust.model.scim.ScimPerson;
import org.gluu.oxtrust.model.scim.ScimPersonPatch;
import org.gluu.oxtrust.model.scim.ScimPersonSearch;
import org.gluu.oxtrust.util.Configuration;

/**
 * User: Dejan Maric
 */
@Path("/Users")
public interface UserWebService {

	@GET
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response listUsers(@Context HttpServletRequest request,
			@QueryParam(Configuration.QUERY_PARAMETER_FILTER) final String filterString,
			@QueryParam(Configuration.QUERY_PARAMETER_SORT_BY) final String sortBy,
			@QueryParam(Configuration.QUERY_PARAMETER_SORT_ORDER) final String sortOrder) throws Exception;

	@Path("{uid}")
	@GET
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response getUserByUid(@Context HttpServletRequest request, @PathParam("uid") String uid) throws Exception;

	@POST
	@Consumes({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response createUser(@Context HttpServletRequest request, ScimPerson person) throws WebApplicationException,
			JsonGenerationException, JsonMappingException, IOException, Exception;

	@Path("{uid}")
	@PUT
	@Consumes({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response updateUser(@Context HttpServletRequest request, @PathParam("uid") String uid, ScimPerson person) throws Exception;

	@Path("{uid}")
	@PATCH
	@Consumes({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response updateUserPatch(@Context HttpServletRequest request, @PathParam("uid") String uid, ScimPersonPatch person);

	@Path("{uid}")
	@DELETE
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response deleteUser(@Context HttpServletRequest request, @PathParam("uid") String uid) throws Exception;

	@Path("/Search")
	@POST
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response personSearch(@Context HttpServletRequest request, ScimPersonSearch searchPattern) throws Exception;

	// todo - Update Password is OPTIONAL and should use PATCH method
	// (http://www.simplecloud.info/specs/draft-scim-api-00.html, 3.3.2.
	// Modifying with PATCH)
	// @Path("{inum}/password")
	// @PUT
	// @Consumes(MediaType.APPLICATION_XML)
	// public Response changePassword(@Context HttpServletRequest request,
	// @PathParam("inum") String inum, String password);
	//
	// @PUT
	// @Consumes(MediaType.APPLICATION_XML)
	// @Produces(MediaType.APPLICATION_XML)
	// @Path("{id}/updatePassword")
	// Response changeLoginPassword(@PathParam("id") String uid, String
	// accessToken);
	//
	// ///////////
	// // Additional Methods
	// @Path("{inum}/passwordpost")
	// @POST
	// @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
	// public Response changePasswordTestHelper(@Context HttpServletRequest
	// request, @PathParam("inum") String inum, @FormParam("password") String
	// password);
	//
	// @Path("{inum}/updatepost")
	// @POST
	// @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
	// public Response updateUserTestHelper(@Context HttpServletRequest request,
	// @PathParam("inum") String inum, @FormParam("person_data") String
	// person_data);
	//
	// @Path("{inum}/createpost")
	// @POST
	// @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
	// public Response createUserTestHelper(@Context HttpServletRequest request,
	// @FormParam("person_data") String person);
	// /////////
}
