package org.gluu.oxtrust.ws.rs;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gluu.oxtrust.model.oxchooser.ForwardedRequest;
import org.gluu.oxtrust.model.oxchooser.InitialID;
import org.gluu.oxtrust.model.scim.ScimPerson;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.discovery.DiscoveryException;

/**
 * oxChooserWebService interface
 * 
 * @author Reda Zerrad Date: 06.28.2012
 */
@Path("/Chooser")
public interface OxChooserWebService {

	@POST
	@Consumes({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response clientIdentification(InitialID id) throws DiscoveryException, Exception;

	@Path("/Request")
	@GET
	@POST
	@Consumes({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response requestHandler(@Context HttpServletRequest request, @Context HttpServletResponse response,
			@QueryParam("idRequest") String idReq) throws Exception;

	@Path("/Response")
	@GET
	@POST
	@Consumes({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response responseHandler(@Context HttpServletRequest httpReq, @Context HttpServletResponse httpRes, ForwardedRequest frequest)
			throws ConsumerException;

	@Path("/AddUser")
	@POST
	@Consumes({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response addUser(@Context HttpServletRequest httpReq, @Context HttpServletResponse httpRes, ScimPerson person) throws Exception;

	@Path("/EditUser/{email}")
	@GET
	@POST
	@Consumes({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response editUser(@Context HttpServletRequest httpReq, @Context HttpServletResponse httpRes, @PathParam("email") String email,
			ScimPerson person_update) throws Exception;

	@Path("/AddUser/{uid}")
	@GET
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response getUserByUid(@Context HttpServletRequest request, @PathParam("uid") String uid) throws Exception;

	@Path("/Test")
	@GET
	@Produces({ MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML })
	public Response getMarshallingTest();

}
