package org.gluu.oxtrust.util;

import org.xdi.util.LDAPConstants;
import org.xdi.util.properties.FileConfiguration;

/**
 * Constants loads the LDAP schema attribute names like uid, iname
 * 
 * @author Pankaj
 * @author Yuriy Movchan Date: 10.14.2010
 */
public final class Configuration extends LDAPConstants {

	public static final String CURRENT_PERSON = "currentPerson";

	public static final String top = "top";
	public static final String objectClassPerson = "gluuPerson";
	public static final String objectClassInumMap = "gluuInumMap";

	public static final String inumDelimiter = "!";
	public static final String inameDelimiter = "*";

	public static final String ouPeople = "ou=people";
	public static final String schemaDN = "cn=schema";

	public static final String inum = "inum";
	public static final String iname = "iname";
	public static final String displayName = "displayName";
	public static final String description = "description";
	public static final String mail = "mail";

	public static final String status = "status";
	public static final String gluuStatus = "gluuStatus";
	public static final String sn = "sn";
	public static final String cn = "cn";
	public static final String owner = "owner";
	public static final String member = "member";

	public static final String RESULT_SUCCESS = "success";
	public static final String RESULT_FAILURE = "failure";
	public static final String RESULT_DUPLICATE = "duplicate";
	public static final String RESULT_DISABLED = "disabled";
	public static final String RESULT_NO_PERMISSIONS = "no_permissions";
	public static final String RESULT_VALIDATION_ERROR = "validation_error";
	public static final String RESULT_LOGOUT = "logout";

	public static final String CACHE_ORGANIZATION_KEY = "organization";
	public static final String CACHE_APPLICATION_NAME = "ApplicationCache";
	public static final String CACHE_ATTRIBUTE_NAME = "AttributeCache";
	public static final String CACHE_LOOKUP_NAME = "LookupCache";

	public static final String CACHE_ATTRIBUTE_KEY_LIST = "attributeList";
	public static final String CACHE_ACTIVE_ATTRIBUTE_KEY_LIST = "activeAttributeList";
	public static final String CACHE_ACTIVE_ATTRIBUTE_NAME = "ActiveAttributeCache";
	public static final String CACHE_ATTRIBUTE_PERSON_KEY_LIST = "personAttributeList";
	public static final String CACHE_ATTRIBUTE_CONTACT_KEY_LIST = "contactAttributeList";
	public static final String CACHE_ATTRIBUTE_CUSTOM_KEY_LIST = "customAttributeList";
	public static final String CACHE_ATTRIBUTE_ORIGIN_KEY_LIST = "attributeOriginList";
	public static final String CACHE_ORGANIZATION_CUSTOM_MESSAGE_KEY = "organizationCustomMessage";

	public static final String EVENT_CLEAR_ATTRIBUTES = "eventClearAttributes";
	public static final String EVENT_CLEAR_ORGANIZATION = "eventClearOrganization";
	public static final String EVENT_PERSON_SAVED = "eventPersonSaved";
	public static final String EVENT_PERSON_UPDATED = "eventPersonUpdated";
	public static final String EVENT_PERSON_DELETED = "eventPersonDeleted";
	public static final String EVENT_PERSON_ADDED_TO_GROUP = "eventPersonAddedToGroup";
	public static final String EVENT_PERSON_REMOVED_FROM_GROUP = "eventPersonRemovedFromGroup";
	public static final String RESULT_LOGOUT_SSO = "logout_sso";
	public static final String RESULT_CAPTCHA_VALIDATION_FAILED = "captcha_validation_failed";

	public static final String APPLICATION_AUTHORIZATION_TYPE = "applicationAuthorizationType";
	public static final String APPLICATION_AUTHORIZATION_NAME_SHIBBOLETH2 = "applicationAuthorizationName_Shibboleth2";

	public static final String CONTENT_TYPE_OCTET_STREAM = "application/octet-stream";
	public static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
	public static final String CONTENT_TYPE_APPLICATION_XML = "application/xml";
	public static final String CONTENT_TYPE_APPLICATION_ZIP = "application/zip";

	public static final String PROGRAM_FACTER = "facter";
	public static final String PROGRAM_DF = "df";

	public static final String FACTER_PARAM_VALUE_DIVIDER = " => ";
	public static final String FACTER_FREE_MEMORY = "memoryfree";
	public static final String FACTER_FREE_MEMORY_TOTAL = "memorysize";
	public static final String FACTER_FREE_SWAP = "swapfree";
	public static final String FACTER_FREE_SWAP_TOTAL = "swapsize";
	public static final String FACTER_HOST_NAME = "hostname";
	public static final String FACTER_IP_ADDRESS = "ipaddress";
	public static final String FACTER_SYSTEM_UP_TIME = "uptime_seconds";
	public static final String FACTER_BANDWIDTH_USAGE = "bandwidth_usage";
	public static final String FACTER_LOAD_AVERAGE = "load_average";
	public static final String CONFIGURATION_FILE_APPLICATION_CONFIGURATION = "oxTrust.properties";
	public static final String CONFIGURATION_FILE_LOCAL_LDAP_PROPERTIES_FILE = "oxTrustLdap.properties";
	public static final String CONFIGURATION_FILE_CENTRAL_LDAP_PROPERTIES_FILE = "oxTrustCentralLdap.properties";
	public static final String CONFIGURATION_FILE_DIASPORA_PROPERTIES_FILE = "oxTrustDiaspora.properties";
	public static final String CONFIGURATION_FILE_CACHE_PROPERTIES_FILE = "oxTrustCacheRefresh.properties";
	public static final String CONFIGURATION_FILE_FOR_LOG_ROTATION = "oxTrustLogRotationConfiguration.xml";

	public static final String HTTPD_TEST_PAGE_NAME = "/index.html";

	public static final String HTTPD_TEST_PAGE_CONTENT = "<html>\n<head>\n<script type=\"text/javascript\">\n<!--\nfunction delayer(){\n    window.location = \"../identity/\"\n}\n//-->\n</script>\n</head>\n<body onLoad=\"setTimeout('delayer()', 5000)\">\n<h2>You are being redirected to appliance login page. Please click this <a href=\"../identity/\">link</a> if your browser does not support javascript.</h2>\n</body>\n</html>\n";

	public static final String PROGRAM_LDAPSEARCH = "/usr/bin/ldapsearch";

	public static final String EVENT_LDAP_CONNECTION_CHECKER_TIMER = "ldapConnectionCheckerTimerEvent";
	public static final String EVENT_METADATA_ENTITY_ID_UPDATE = "metadataEntityIdUpdate";
	public static final String EVENT_CACHE_REFRESH_TIMER = "cacheRefreshTimerEvent";
	public static final String CUSTOM_MESSAGE_LOGIN_PAGE = "loginPage";
	public static final String CUSTOM_MESSAGE_WELCOME_PAGE = "welcomePage";
	public static final String CUSTOM_MESSAGE_TITLE_TEXT = "welcomeTitle";

	public static final String PROGRAM_CHECK_SSL = "check_ssl";

	public static final char[] HEX_CHARACTERS = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };

	private static Configuration instance;
	private static Object lock = new Object();

	public static String ouAppliances = "ou=appliances";

	public static final String INUM_TYPE_PEOPLE_SLUG = "people";
	public static final String INUM_TYPE_GROUP_SLUG = "group";
	public static final String INUM_TYPE_ATTRIBUTE_SLUG = "attribute";
	public static final String INUM_TYPE_TRUST_RELATNSHIP_SLUG = "trelationship";
	public static final String OXAUTH_CLIENT_ID = "client_id";
	public static final String OXAUTH_CLIENT_PASSWORD = "client_password";
	public static final String OXAUTH_CLIENT_CREDENTIALS = "client_credentials";
	public static final String OXAUTH_REDIRECT_URI = "redirect_uri";
	public static final String OXAUTH_RESPONSE_TYPE = "response_type";
	public static final String OXAUTH_SCOPE = "scope";
	public static final String OXAUTH_STATE = "state";
	public static final String OXAUTH_CODE = "code";
	public static final String OXAUTH_ID_TOKEN = "id_token";
	public static final String OXAUTH_ERROR = "error";
	public static final String OXAUTH_NONCE = "nonce";
	public static final String OXAUTH_ERROR_DESCRIPTION = "error_description";
	public static final String OXAUTH_ACCESS_TOKEN = "access_token";
	public static final String OXAUTH_AUTH_MODE = "auth_mode";
	public static final String OXAUTH_AUTH_LEVEL = "auth_level";

	public static final String INUM_PERSON_OBJECTTYPE = "0000";
	public static final String INUM_GROUP_OBJECTTYPE = "0003";
	public static final String INAME_PERSON_OBJECTTYPE = "person";
	public static final String INAME_OXPLUS = "oxplus";
	public static final String INAME_CLASS_OBJECTTYPE = "class";

	public static final String SELF_LINK_CONTRACT = "$self";
	public static final String ADMIN_LINK_CONTRACT = "*linkcontract*manager";

	public static final int searchPersonsSizeLimit = 100;
	public static final int searchGroupSizeLimit = 100;

	// SCIM
	/**
	 * The HTTP query parameter used in a URI to select specific SCIM
	 * attributes.
	 */
	public static final String QUERY_PARAMETER_ATTRIBUTES = "attributes";

	/**
	 * The HTTP query parameter used in a URI to provide a filter expression.
	 */
	public static final String QUERY_PARAMETER_FILTER = "filter";

	/**
	 * The HTTP query parameter used in a URI to sort by a SCIM attribute.
	 */
	public static final String QUERY_PARAMETER_SORT_BY = "sortBy";

	/**
	 * The HTTP query parameter used in a URI to specify the sort order.
	 */
	public static final String QUERY_PARAMETER_SORT_ORDER = "sortOrder";

	/**
	 * The HTTP query parameter used in a URI to specify the starting index for
	 * page results.
	 */
	public static final String QUERY_PARAMETER_PAGE_START_INDEX = "startIndex";

	/**
	 * The HTTP query parameter used in a URI to specify the maximum size of a
	 * page of results.
	 */
	public static final String QUERY_PARAMETER_PAGE_SIZE = "count";

	private static class ConfigurationSingleton {
		static Configuration INSTANCE = new Configuration();
	}

	private FileConfiguration applicationConfiguration;

	private Configuration() {
		applicationConfiguration = new FileConfiguration(CONFIGURATION_FILE_APPLICATION_CONFIGURATION);
	}

	public static Configuration instance() {
		// Just define the singleton as a static field in a separate class.
		// The semantics of Java guarantee that the field will not be
		// initialized until the field is referenced,
		// and that any thread which accesses the field will see all of the
		// writes resulting from initializing that field.
		// http://www.cs.umd.edu/~pugh/java/memoryModel/DoubleCheckedLocking.html
		return ConfigurationSingleton.INSTANCE;
	}

	public static String getAdminLinkContract() {
		return getAdminLinkContract(false);
	}

	public static String getAdminLinkContract(boolean isSelf) {
		if (isSelf) {
			return SELF_LINK_CONTRACT;
		}
		return instance().getOrgInum() + ADMIN_LINK_CONTRACT;
	}

	public String getBaseDN() {
		return applicationConfiguration.getString("baseDN");
	}

	public String getOrgInum() {
		return applicationConfiguration.getString("orgInum");
	}

	public String getOrgIname() {
		return applicationConfiguration.getString("orgIname");
	}

	public String getLdifStore() {
		return applicationConfiguration.getString("ldifStoreDir");
	}

	public String getApplianceIname() {
		return applicationConfiguration.getString("applianceIname");
	}

	public String getSchemaAddObjectClassWithoutAttributeTypesDefinition() {
		return applicationConfiguration.getString("schema.add-without-attribute-types.objectClass.objectClasses");
	}

	public String getSchemaAddObjectClassWithAttributeTypesDefinition() {
		return applicationConfiguration.getString("schema.add-with-attribute-types.objectClass.objectClasses");
	}

	public String[] getPersonObjectClassTypes() {
		return applicationConfiguration.getStringArray("person-objectClass-types");
	}

	public String getPersonCustomObjectClass() {
		return applicationConfiguration.getString("custom-object-class");
	}

	public String[] getPersonObjectClassDisplayNames() {
		return applicationConfiguration.getStringArray("person-objectClass-displayNames");
	}

	public String getSchemaAddAttributeDefinition() {
		return applicationConfiguration.getString("schema.add.attribute.attributeTypes");
	}

	public String[] getContactObjectClassTypes() {
		return applicationConfiguration.getStringArray("contact-objectClass-types");
	}

	public String[] getContactObjectClassDisplayNames() {
		return applicationConfiguration.getStringArray("contact-objectClass-displayNames");
	}

	public String getApplianceInum() {
		return applicationConfiguration.getString("applianceInum");
	}

	public String getPhotoRepositoryRootDir() {
		return applicationConfiguration.getString("photo.repository.root-dir");
	}

	public int getPhotoRepositoryThumbWidth() {
		return applicationConfiguration.getInt("photo.repository.thumb-width");
	}

	public int getPhotoRepositoryThumbHeight() {
		return applicationConfiguration.getInt("photo.repository.thumb-height");
	}

	public int getPhotoRepositoryCountLeveles() {
		return applicationConfiguration.getInt("photo.repository.count-levels");
	}

	public int getPhotoRepositoryCountFoldersPerLevel() {
		return applicationConfiguration.getInt("photo.repository.count-folders-per-level");
	}

	public String getShibboleth2IdpRootDir() {
		return applicationConfiguration.getString("shibboleth2.idp.root-dir");
	}

	public String getShibboleth2SpConfDir() {
		return applicationConfiguration.getString("shibboleth2.sp.conf-dir");
	}

	public String getPokenApplicationSecret() {
		return applicationConfiguration.getString("poken.application.secret");
	}

	public boolean isUpdateApplianceStatus() {
		return applicationConfiguration.getBoolean("site.update-appliance-status");
	}

	public String getSvnConfigurationStoreRoot() {
		return applicationConfiguration.getString("svn.configuration-store.root");
	}

	public String getSvnConfigurationStorePassword() {
		return applicationConfiguration.getString("svn.configuration-store.password");
	}

	public String getKeystorePath() {
		return applicationConfiguration.getString("keystore.path");
	}

	public String getKeystorePassword() {
		return applicationConfiguration.getString("keystore.password");
	}

	public boolean isAllowPersonModification() {
		return applicationConfiguration.getBoolean("person.allow-modification");
	}

	public String getIdpUrl() {
		return applicationConfiguration.getString("idp.url");
	}

	public String getVelocityLog() {
		return applicationConfiguration.getString("velocity.log");
	}

	public String getSPMetadataPath() {
		return applicationConfiguration.getString("gluuSP.metadata");
	}

	public String getLogoLocation() {
		return applicationConfiguration.getString("logo.location");
	}

	public String getGluuSvnRevisionVersion() {
		return Version.GLUU_SVN_REVISION_VERSION;
	}

	public String getGluuSvnRevisionDate() {
		return Version.GLUU_SVN_REVISION_DATE;
	}

	public String getGluuBuildDate() {
		return Version.GLUU_BUILD_DATE;
	}

	public String getIdpSecurityKey() {
		return applicationConfiguration.getString("idp.securityKey");
	}

	public String getIdpSecurityKeyPassword() {
		return applicationConfiguration.getString("idp.securityKeyPassword");
	}

	public String getIdpSecurityCert() {
		return applicationConfiguration.getString("idp.securityCert");
	}

	public String[] getGluuSPAttributes() {
		return applicationConfiguration.getStringArray("gluuSP.shared.attributes");
	}

	public boolean isConfigGeneration() {
		return "enabled".equalsIgnoreCase(applicationConfiguration.getString("configGeneration"));
	}

	public String getIdpLdapProtocol() {
		return "true".equalsIgnoreCase(applicationConfiguration.getString("idp.useSSL")) ? "ldaps" : "ldap";

	}

	public String getIdpLdapServer() {
		return applicationConfiguration.getString("idp.ldap.server");

	}

	public String getIdpBindDn() {
		return applicationConfiguration.getString("idp.bindDN");

	}

	public String getIdpBindPassword() {
		return applicationConfiguration.getString("idp.bindPassword");
	}

	public String getGluuSPCert() {
		return applicationConfiguration.getString("gluuSP.securityCert");
	}

	public String getApplianceUrl() {
		return applicationConfiguration.getString("appliance.url");
	}

	public String getVDSLdapProtocol() {
		return "true".equalsIgnoreCase(applicationConfiguration.getString("vds.useSSL")) ? "ldaps" : "ldap";
	}

	public String getVDSBindDn() {
		return applicationConfiguration.getString("vds.bindDN");
	}

	public String getVDSLdapServer() {
		return applicationConfiguration.getString("vds.ldap.server");

	}

	public String getVDSBindPassword() {
		return applicationConfiguration.getString("vds.bindPassword");

	}

	public String getVDSFilter() {
		return applicationConfiguration.getString("vds.test.filter");
	}

	public String getVDSUserField() {
		return applicationConfiguration.getString("vds.userField");
	}

	public String getMysqlUrl() {
		return applicationConfiguration.getString("mysql.url");
	}

	public String getMysqlUser() {
		return applicationConfiguration.getString("mysql.user");
	}

	public String getMysqlPassword() {
		return applicationConfiguration.getString("mysql.password");
	}

	public String getShibboleth2FederationRootDir() {
		return applicationConfiguration.getString("shibboleth2.federation.root-dir");
	}

	public boolean isCacheRefreshEnabled() {
		return applicationConfiguration.getBoolean("cache.refresh.enabled", false);
	}

	public int getCacheRefreshIntervalMinutes() {
		return applicationConfiguration.getInt("cache.refresh.interval.minutes", -1);
	}

	public String getCACertsLocation() {
		return applicationConfiguration.getString("cacertsLocation");
	}

	public String getCACertsPassphrase() {
		return applicationConfiguration.getString("cacertsPassphrase");
	}

	public String getTempCertDir() {
		return applicationConfiguration.getString("certDirTemp");
	}

	public String getCertDir() {
		return applicationConfiguration.getString("certDir");
	}

	public String getServicesRestartTrigger() {
		return applicationConfiguration.getString("servicesRestartTrigger");
	}

	public boolean isPersistSVN() {
		return applicationConfiguration.getBoolean("persist-in-svn");
	}

	public String getOxAuthAuthorizeUrl() {
		return applicationConfiguration.getString("oxauth.authorize.url");
	}

	public String getOxAuthTokenUrl() {
		return applicationConfiguration.getString("oxauth.token.url");
	}

	public String getOxAuthValidateTokenUrl() {
		return applicationConfiguration.getString("oxauth.token.validate.url");
	}

	public String getOxAuthCheckSessionUrl() {
		return applicationConfiguration.getString("oxauth.checksession.url");
	}

	public String getOxAuthLogoutUrl() {
		return applicationConfiguration.getString("oxauth.logout.url");
	}

	public String getLoginRedirectUrl() {
		return applicationConfiguration.getString("login.redirect.url");
	}

	public String getLogoutRedirectUrl() {
		return applicationConfiguration.getString("logout.redirect.url");
	}

	public String getOxAuthClientId() {
		return applicationConfiguration.getString("oxauth.client.id");
	}

	public String getOxAuthClientPassword() {
		return applicationConfiguration.getString("oxauth.client.password");
	}

	public String getOxAuthClientScope() {
		return applicationConfiguration.getString("oxauth.client.scope");
	}

	public String getOrgDisplayName() {
		return applicationConfiguration.getString("orgDisplayName");
	}

	public String getOrgShortName() {
		return applicationConfiguration.getString("orgShortName");
	}

	public String getOxPlusIname() {
		return applicationConfiguration.getString("oxplusIname");
	}

	public String[] getClusteredInums() {
		return applicationConfiguration.getStringArray("clusteredInums");
	}

	public String getOxPlussClassXri() {
		return applicationConfiguration.getString("oxPlus.class.xri");
	}

	public String getAuthMode() {

		return applicationConfiguration.getString("oxtrust.auth.mode");
	}

	public Boolean isSelfTestEnabled() {
		return applicationConfiguration.getBoolean("self-test.enabled");
	}

	public String getSelfTestProgramToStart() {
		return applicationConfiguration.getString("self-test.program.start");
	}

	public String getSelfTestProgramWorkingFolder() {
		return applicationConfiguration.getString("self-test.program.working-folder");
	}

	public String getOxAuthTokenValidationUrl() {

		return applicationConfiguration.getString("oxauth.token.validation.url");
	}

	public String getOxAuthUserInfo() {

		return applicationConfiguration.getString("oxauth.userinfo.url");
	}

	public String getScimGroup() {

		return applicationConfiguration.getString("scim.group.iname");
	}

	public String getClientAssociationAttribute() {
		return applicationConfiguration.getString("client.association.attribute");
	}

	public boolean isIgnoreValidation() {
		return applicationConfiguration.getBoolean("ignoreValidation", false);
	}

}
