package org.gluu.oxtrust.model.uma;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

import org.gluu.oxtrust.model.InumEntry;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;

/**
 * UMA scope description LDAP model
 * 
 * @author Yuriy Movchan Date: 10/03/2012
 */
@LdapEntry(sortBy = { "displayName" })
@LdapObjectClass(values = { "top", "oxAuthUmaScopeDescription" })
public class ScopeDescription extends InumEntry {

	@NotNull
	@Size(min = 4, max = 30, message = "Length of scope name should be between 4 and 30")
	@Pattern(regexp = "^[a-zA-Z\\d_]{4,30}$", message = "Invalid scope name")
	@LdapAttribute(name = "oxId")
	private String id;

	@LdapAttribute(name = "oxFaviconImage")
	private String icon;

	@NotNull(message = "Display name should be not empty")
	@LdapAttribute
	private String displayName;

	@LdapAttribute(name = "oxPolicyRule")
	private String policyRule;

	@LdapAttribute(name = "oxRevision")
	private String rev;

	@LdapAttribute
	private String owner;

	private transient boolean selected;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getIcon() {
		return icon;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	public String getDisplayName() {
		return displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public String getPolicyRule() {
		return policyRule;
	}

	public void setPolicyRule(String policyRule) {
		this.policyRule = policyRule;
	}

	public String getRev() {
		return rev;
	}

	public void setRev(String rev) {
		this.rev = rev;
	}

	public String getOwner() {
		return owner;
	}

	public void setOwner(String owner) {
		this.owner = owner;
	}

	public boolean isSelected() {
		return selected;
	}

	public void setSelected(boolean selected) {
		this.selected = selected;
	}

}
