package org.gluu.oxtrust.model.uma;

import java.io.Serializable;

import org.xdi.oxauth.model.uma.MetadataConfiguration;

/**
 * Host specific information needed to communicate with UMA AM
 * 
 * @author Yuriy Movchan
 * @version 0.1, 12/08/2012
 */
public class HostToken implements Serializable {

	private static final long serialVersionUID = -550731950044674768L;

	private String hostInum, hostClientInum;
	private String token;
	private long expiredAt;

	private MetadataConfiguration metadataConfiguration;

	public HostToken(String hostInum, String hostClientInum, MetadataConfiguration metadataConfiguration, String token, long expiredAt) {
		this.hostInum = hostInum;
		this.hostClientInum = hostClientInum;
		this.metadataConfiguration = metadataConfiguration;
		this.token = token;
		this.expiredAt = expiredAt;
	}

	public String getHostInum() {
		return hostInum;
	}

	public void setHostInum(String hostInum) {
		this.hostInum = hostInum;
	}

	public String getHostClientInum() {
		return hostClientInum;
	}

	public void setHostClientInum(String hostClientInum) {
		this.hostClientInum = hostClientInum;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public long getExpiredAt() {
		return expiredAt;
	}

	public void setExpiredAt(long expiredAt) {
		this.expiredAt = expiredAt;
	}

	public MetadataConfiguration getMetadataConfiguration() {
		return metadataConfiguration;
	}

	public void setMetadataConfiguration(MetadataConfiguration metadataConfiguration) {
		this.metadataConfiguration = metadataConfiguration;
	}

}