package org.gluu.oxtrust.model;

import java.util.Date;

import javax.validation.constraints.NotNull;

import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;

/**
 * UMA host LDAP model
 * 
 * @author Yuriy Movchan Date: 12/11/2012
 */
@LdapEntry(sortBy = { "displayName" })
@LdapObjectClass(values = { "top", "oxAuthUmaHost" })
public class OxAuthHost extends InumEntry {

	@NotNull(message = "Host name should be not empty")
	@LdapAttribute(name = "oxId")
	private String id;

	@NotNull(message = "Display name should be not empty")
	@LdapAttribute
	private String displayName;

	@LdapAttribute(name = "registrationDate")
	private Date registrationDate;

	@LdapAttribute(name = "oxRevision")
	private String rev;

	@LdapAttribute
	private String owner;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getDisplayName() {
		return displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public Date getRegistrationDate() {
		return registrationDate;
	}

	public void setRegistrationDate(Date registrationDate) {
		this.registrationDate = registrationDate;
	}

	public String getRev() {
		return rev;
	}

	public void setRev(String rev) {
		this.rev = rev;
	}

	public String getOwner() {
		return owner;
	}

	public void setOwner(String owner) {
		this.owner = owner;
	}

}
