package org.gluu.oxtrust.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.xdi.util.security.StringEncrypter;
import org.xdi.util.security.StringEncrypter.EncryptionException;

/**
 * LDAPConfig
 * 
 * @author Reda Zerrad Date: 08.14.2012
 */

@XmlRootElement(name = "User")
@XmlAccessorType(XmlAccessType.FIELD)
@JsonPropertyOrder({ "ldapHost", "ldapPort", "ldapBindDn", "ldapBindPw", "ldapUseSSL", "ldapEnabled" })
@JsonIgnoreProperties({ "decodedBindPw" })
@XmlType(propOrder = { "ldapHost", "ldapPort", "ldapBindDn", "ldapBindPw", "ldapUseSSL", "ldapEnabled" })
public class LdapConfig {

	private String ldapHost;
	private String ldapPort;
	private String ldapBindDn;
	private String ldapBindPw;
	private boolean ldapUseSSL;
	private boolean ldapEnabled;
	@XmlTransient
	private String decodedBindPw;
	private int priority;

	public LdapConfig() {
		ldapHost = "";
		ldapPort = "";
		ldapBindDn = "";
		ldapBindPw = "";

	}

	public String getLdapHost() {
		return this.ldapHost;
	}

	public void setLdapHost(String ldapHost) {
		this.ldapHost = ldapHost;
	}

	public String getLdapPort() {
		return this.ldapPort;
	}

	public void setLdapPort(String ldapPort) {
		this.ldapPort = ldapPort;
	}

	public String getLdapBindDn() {
		return this.ldapBindDn;
	}

	public void setLdapBindDn(String ldapBindDn) {
		this.ldapBindDn = ldapBindDn;
	}

	public String getLdapBindPw() {
		return this.ldapBindPw;
	}

	public void setLdapBindPw(String ldapBindPw) {
		this.ldapBindPw = ldapBindPw;
	}

	public boolean isLdapUseSSL() {
		return ldapUseSSL;
	}

	public void setLdapUseSSL(boolean ldapUseSSL) {
		this.ldapUseSSL = ldapUseSSL;
	}

	public String getDecodedBindPw() throws EncryptionException {
		return this.decodedBindPw = StringEncrypter.defaultInstance().decrypt(this.ldapBindPw);
	}

	public void setDecodedBindPw(String decodedBindPw) throws EncryptionException {
		this.decodedBindPw = decodedBindPw;
		if (decodedBindPw != null && !decodedBindPw.trim().equalsIgnoreCase("")) {
			this.ldapBindPw = StringEncrypter.defaultInstance().encrypt(this.decodedBindPw);
		}
	}

	public int getPriority() {
		return this.priority;
	}

	public void setPriority(int priority) {
		this.priority = priority;
	}

	public boolean getLdapEnabled() {
		return this.ldapEnabled;
	}

	public void setLdapEnabled(boolean ldapEnabled) {
		this.ldapEnabled = ldapEnabled;
	}

	public boolean getIsEnabled() {
		return this.ldapEnabled;
	}

	public void setIsEnabled(boolean isEnabled) {
		this.ldapEnabled = isEnabled;
	}

}
