package org.gluu.oxtrust.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import org.gluu.oxtrust.ldap.service.TrustService;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;

@LdapEntry
@LdapObjectClass(values = { "top", "gluuSAMLconfig" })
public class GluuSAMLTrustRelationship extends InumEntry implements Serializable {

	private static final long serialVersionUID = 5907443836820485369L;

	@LdapAttribute(ignoreDuringUpdate = true)
	private String inum;

	@LdapAttribute(ignoreDuringUpdate = true)
	private String iname;

	@NotNull
	@Size(min = 0, max = 60, message = "Length of the Display Name should not exceed 60")
	@LdapAttribute
	private String displayName;

	@NotNull
	@Size(min = 0, max = 4000, message = "Length of the Description should not exceed 4000")
	@LdapAttribute
	private String description;

	@LdapAttribute(name = "gluuStatus")
	private GluuStatus status;

	@LdapAttribute(name = "gluuValidationStatus")
	private GluuValidationStatus validationStatus;

	@LdapAttribute(name = "gluuReleasedAttribute")
	private List<String> releasedAttributes;

	@NotNull
	@LdapAttribute(name = "gluuSAMLspMetaDataSourceType")
	private GluuMetadataSourceType spMetaDataSourceType;

	@LdapAttribute(name = "gluuSAMLspMetaDataFN")
	private String spMetaDataFN;

	@LdapAttribute(name = "gluuSAMLspMetaDataURL")
	private String spMetaDataURL;

	@LdapAttribute(name = "o")
	private String owner;

	@LdapAttribute(name = "gluuSAMLmaxRefreshDelay")
	private String maxRefreshDelay;

	@Transient
	private transient List<GluuCustomAttribute> releasedCustomAttributes = new ArrayList<GluuCustomAttribute>();

	private Map<String, MetadataFilter> metadataFilters = new HashMap<String, MetadataFilter>();

	private Map<String, ProfileConfiguration> profileConfigurations = new HashMap<String, ProfileConfiguration>();

	@LdapAttribute(name = "gluuSAMLMetaDataFilter")
	private List<String> gluuSAMLMetaDataFilter;

	@LdapAttribute(name = "gluuTrustContact")
	private List<String> gluuTrustContact;

	private List<DeconstructedTrustRelationship> deconstructedTrustRelationships = new ArrayList<DeconstructedTrustRelationship>();

	@LdapAttribute(name = "gluuTrustDeconstruction")
	private List<String> gluuTrustDeconstruction;

	@LdapAttribute(name = "gluuContainerFederation")
	protected String gluuContainerFederation;

	@LdapAttribute(name = "gluuIsFederation")
	private String gluuIsFederation;

	@LdapAttribute(name = "gluuEntityId")
	private List<String> gluuEntityId;

	@LdapAttribute(name = "gluuProfileConfiguration")
	private List<String> gluuProfileConfiguration;

	@LdapAttribute(name = "gluuSpecificRelyingPartyConfig")
	private String gluuSpecificRelyingPartyConfig;

	@LdapAttribute(name = "url")
	private String url;

	@LdapAttribute(name = "gluuValidationLog")
	private List<String> validationLog;

	public String getInum() {
		return inum;
	}

	public void setInum(String inum) {
		this.inum = inum;
	}

	public String getIname() {
		return iname;
	}

	public void setIname(String iname) {
		this.iname = iname;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public GluuStatus getStatus() {
		return status;
	}

	public void setStatus(GluuStatus status) {
		this.status = status;
	}

	public List<String> getReleasedAttributes() {
		return releasedAttributes;
	}

	public void setReleasedAttributes(List<String> releasedAttributes) {
		this.releasedAttributes = releasedAttributes;
	}

	public String getDisplayName() {
		return displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public GluuMetadataSourceType getSpMetaDataSourceType() {
		return spMetaDataSourceType;
	}

	public void setSpMetaDataSourceType(GluuMetadataSourceType spMetaDataSourceType) {
		this.spMetaDataSourceType = spMetaDataSourceType;
	}

	public String getSpMetaDataFN() {
		return spMetaDataFN;
	}

	public void setSpMetaDataFN(String spMetaDataFN) {
		this.spMetaDataFN = spMetaDataFN;
	}

	public String getSpMetaDataURL() {
		return spMetaDataURL;
	}

	public void setSpMetaDataURL(String spMetaDataURL) {
		this.spMetaDataURL = spMetaDataURL;
	}

	public String getOwner() {
		return owner;
	}

	public void setOwner(String owner) {
		this.owner = owner;
	}

	public List<GluuCustomAttribute> getReleasedCustomAttributes() {
		return releasedCustomAttributes;
	}

	public void setReleasedCustomAttributes(List<GluuCustomAttribute> releasedCustomAttributes) {
		Collections.sort(releasedCustomAttributes);
		this.releasedCustomAttributes = releasedCustomAttributes;
	}

	public void setMaxRefreshDelay(String maxRefreshDelay) {
		this.maxRefreshDelay = maxRefreshDelay;
	}

	public String getMaxRefreshDelay() {
		return maxRefreshDelay;
	}

	public Map<String, MetadataFilter> getMetadataFilters() {
		return metadataFilters;
	}

	public void setMetadataFilters(Map<String, MetadataFilter> metadataFilters) {
		this.metadataFilters = metadataFilters;
	}

	public Map<String, ProfileConfiguration> getProfileConfigurations() {
		return profileConfigurations;
	}

	public void setProfileConfigurations(Map<String, ProfileConfiguration> profileConfigurations) {
		this.profileConfigurations = profileConfigurations;
	}

	public List<String> getGluuSAMLMetaDataFilter() {
		return gluuSAMLMetaDataFilter;
	}

	public void setGluuSAMLMetaDataFilter(List<String> gluuSAMLMetaDataFilter) {
		this.gluuSAMLMetaDataFilter = gluuSAMLMetaDataFilter;
	}

	public void setGluuTrustContact(List<String> gluuTrustContact) {
		this.gluuTrustContact = gluuTrustContact;
	}

	public List<String> getGluuTrustContact() {
		return gluuTrustContact;
	}

	public void setDeconstructedTrustRelationships(List<DeconstructedTrustRelationship> deconstructedTrustRelationships) {
		this.deconstructedTrustRelationships = deconstructedTrustRelationships;
	}

	public List<DeconstructedTrustRelationship> getDeconstructedTrustRelationships() {
		return deconstructedTrustRelationships;
	}

	public void setGluuTrustDeconstruction(List<String> gluuTrustDeconstruction) {
		this.gluuTrustDeconstruction = gluuTrustDeconstruction;
	}

	public List<String> getGluuTrustDeconstruction() {
		return this.gluuTrustDeconstruction;
	}

	public void setFederation(boolean isFederation) {
		this.gluuIsFederation = Boolean.toString(isFederation);
	}

	public boolean isFederation() {
		return Boolean.parseBoolean(gluuIsFederation);
	}

	public void setContainerFederation(GluuSAMLTrustRelationship containerFederation) {
		this.gluuContainerFederation = containerFederation.getDn();
	}

	public GluuSAMLTrustRelationship getContainerFederation() {
		return TrustService.instance().getRelationshipByDn(this.gluuContainerFederation);
	}

	public void setGluuIsFederation(String gluuIsFederation) {
		this.gluuIsFederation = gluuIsFederation;
	}

	public String getGluuIsFederation() {
		return gluuIsFederation;
	}

	public void setGluuContainerFederation(String gluuContainerFederation) {
		this.gluuContainerFederation = gluuContainerFederation;
	}

	public String getGluuContainerFederation() {
		return gluuContainerFederation;
	}

	@Override
	public String toString() {
		return String
				.format("GluuSAMLTrustRelationship [description=%s, displayName=%s, iname=%s, inum=%s, owner=%s, releasedAttributes=%s, spMetaDataFN=%s, spMetaDataSourceType=%s, spMetaDataURL=%s, status=%s, toString()=%s]",
						description, displayName, iname, inum, owner, releasedAttributes, spMetaDataFN, spMetaDataSourceType,
						spMetaDataURL, status, super.toString());
	}

	@Override
	public boolean equals(Object o) {
		if (!(o instanceof GluuSAMLTrustRelationship)) {
			return false;
		}

		if (getInum() == null) {
			return getInum() == ((GluuSAMLTrustRelationship) o).getInum();
		}

		return getInum().equals(((GluuSAMLTrustRelationship) o).getInum());
	}

	public void setGluuEntityId(Set<String> gluuEntityId) {
		this.gluuEntityId = new ArrayList<String>(gluuEntityId);
	}
	/**
	 * This method is for ldap persistance only. For purposes of crud - please use setGluuEntityId(Set<String> gluuEntityId)
	 */
	@Deprecated
	public void setGluuEntityId(List<String> gluuEntityId) {
		this.gluuEntityId = gluuEntityId;
	}
	
	public List<String> getGluuEntityId() {
		return gluuEntityId;
	}

	/**
	 * This method returns entityId for site TRs only.
	 */
	public String getEntityId() {
		if ((gluuEntityId != null) && (gluuEntityId.size() == 1)) {
			return gluuEntityId.get(0);
		}
		return null;
	}

	public void setEntityId(String entityId) {
		Set<String> entityIds = new TreeSet<String>();
		entityIds.add(entityId);
		setGluuEntityId(entityIds);
	}

	public void setGluuProfileConfiguration(List<String> gluuProfileConfiguration) {
		this.gluuProfileConfiguration = gluuProfileConfiguration;

	}

	public List<String> getGluuProfileConfiguration() {
		return this.gluuProfileConfiguration;
	}

	public void setGluuSpecificRelyingPartyConfig(String gluuSpecificRelyingPartyConfig) {
		this.gluuSpecificRelyingPartyConfig = gluuSpecificRelyingPartyConfig;
	}

	public String getGluuSpecificRelyingPartyConfig() {
		return gluuSpecificRelyingPartyConfig;
	}

	public void setSpecificRelyingPartyConfig(boolean specificRelyingPartyConfig) {
		this.gluuSpecificRelyingPartyConfig = Boolean.toString(specificRelyingPartyConfig);
	}

	public boolean getSpecificRelyingPartyConfig() {
		return Boolean.parseBoolean(gluuSpecificRelyingPartyConfig);
	}

	public GluuValidationStatus getValidationStatus() {
		return validationStatus;
	}

	public void setValidationStatus(GluuValidationStatus validationStatus) {
		this.validationStatus = validationStatus;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getUrl() {
		return url;
	}

	/**
	 * @return the validationLog
	 */
	public List<String> getValidationLog() {
		return validationLog;
	}

	/**
	 * @param validationLog
	 *            the validationLog to set
	 */
	public void setValidationLog(List<String> validationLog) {
		this.validationLog = validationLog;
	}

}
