package org.gluu.oxtrust.ldap.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

import org.gluu.oxtrust.model.GluuImage;
import org.gluu.oxtrust.model.TrustContact;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;

/**
 * Service class to work with images in photo repository
 * 
 * @author Yuriy Movchan Date: 01.11.2011
 */
@Name("xmlService")
@Scope(ScopeType.APPLICATION)
@AutoCreate
public class XmlService {

	@Logger
	private Log log;

	private JAXBContext jaxbContext;
	private Marshaller jaxbMarshaller;
	private Unmarshaller jaxbUnmarshaller;

	@Create
	public void init() {
		try {
			this.jaxbContext = JAXBContext.newInstance(GluuImage.class, TrustContact.class);
			this.jaxbMarshaller = this.jaxbContext.createMarshaller();
			this.jaxbUnmarshaller = this.jaxbContext.createUnmarshaller();
		} catch (JAXBException ex) {
			log.error("Failed to create JAXB marshaller and unmarshaller", ex);
		}
	}

	public String getXMLFromGluuImage(GluuImage photo) {
		if (photo == null) {
			return null;
		}

		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		try {
			this.jaxbMarshaller.marshal(photo, bos);
			return new String(bos.toByteArray(), "UTF-8");
		} catch (Exception ex) {
			log.error("Failed to convert GluuImage {0} to XML", ex, photo);
		}

		return null;
	}

	public GluuImage getGluuImageFromXML(String xml) {
		if (xml == null) {
			return null;
		}

		try {
			ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes("UTF-8"));
			return (GluuImage) this.jaxbUnmarshaller.unmarshal(bis);
		} catch (Exception ex) {
			log.error("Failed to create GluuImage from XML {0}", ex, xml);
		}

		return null;
	}

	public TrustContact getTrustContactFromXML(String xml) {
		if (xml == null) {
			return null;
		}

		try {
			ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes("UTF-8"));
			return (TrustContact) this.jaxbUnmarshaller.unmarshal(bis);
		} catch (Exception ex) {
			log.error("Failed to create TrustContact from XML {0}", ex, xml);
		}

		return null;
	}

	// public String
	// getXMLFromDeconstructedTrustRelationship(DeconstructedTrustRelationship
	// deconstructedTR) {
	// if (deconstructedTR == null) {
	// return null;
	// }
	//
	// ByteArrayOutputStream bos = new ByteArrayOutputStream();
	// try {
	// this.jaxbMarshaller.marshal(deconstructedTR, bos);
	// return new String(bos.toByteArray(), "UTF-8");
	// } catch (Exception ex) {
	// log.error("Failed to convert DeconstructedTrustRelationship {0} to XML",
	// ex, deconstructedTR);
	// }
	//
	// return null;
	// }
	//
	// public DeconstructedTrustRelationship
	// getDeconstructedTrustRelationshipFromXML(String xml) {
	// if (xml == null) {
	// return null;
	// }
	//
	// try {
	// ByteArrayInputStream bis = new
	// ByteArrayInputStream(xml.getBytes("UTF-8"));
	// return (DeconstructedTrustRelationship)
	// this.jaxbUnmarshaller.unmarshal(bis);
	// } catch (Exception ex) {
	// log.error("Failed to create DeconstructedTrustRelationship from XML {0}",
	// ex, xml);
	// }
	//
	// return null;
	// }

	public String getXMLFromTrustContact(TrustContact contact) {
		if (contact == null) {
			return null;
		}

		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		try {
			this.jaxbMarshaller.marshal(contact, bos);
			return new String(bos.toByteArray(), "UTF-8");
		} catch (Exception ex) {
			log.error("Failed to convert TrustContact {0} to XML", ex, contact);
		}

		return null;
	}

	/**
	 * Get xmlService instance
	 * 
	 * @return XmlService instance
	 */
	public static XmlService instance() {
		return (XmlService) Component.getInstance(XmlService.class);
	}

}
