package org.gluu.oxtrust.action;

import java.io.Serializable;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Size;

import org.gluu.oxtrust.ldap.service.PersonService;
import org.gluu.oxtrust.model.GluuCustomPerson;
import org.gluu.site.ldap.persistence.exception.AuthenticationException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.log.Log;
import org.xdi.util.StringHelper;

/**
 * Action class for password validation
 * 
 * @author Yuriy Movchan Date: 12/20/2012
 */
@Scope(ScopeType.EVENT)
@Name("passwordValidationAction")

public class PasswordValidationAction implements Cloneable, Serializable {

	private static final long serialVersionUID = 1952428504080910113L;

	@Logger
	private Log log;

	@In
	private PersonService personService;

	private String oldPassword = "";

	@Size(min = 3, max = 60, message = "Password length must be between {min} and {max} characters.")
	private String password = "";

	@Size(min = 3, max = 60, message = "Password length must be between {min} and {max} characters.")
	private String confirm = "";

	private UIComponent graphValidator;

	@AssertTrue(message = "Different passwords entered!")
	public boolean isPasswordsEquals() {
		return password.equals(confirm);
	}

	public void reset() {
		this.password = this.confirm = null;
	}

	public void storeNewPassword(GluuCustomPerson person, boolean validateOldPassword) {
		if (validateOldPassword) {
			boolean resultValidateOldPassword = false;
			try {
				if ((person != null) && StringHelper.isNotEmpty(person.getUid())) {
					resultValidateOldPassword = personService.authenticate(person.getUid(), oldPassword);
				}
			} catch (AuthenticationException ex) {
				log.debug("Failed to verify old person password", ex);
			}

			if (!resultValidateOldPassword) {
				if (graphValidator == null) {
					FacesContext.getCurrentInstance().addMessage(null,
							new FacesMessage(FacesMessage.SEVERITY_ERROR, "Old password isn't valid!", "Old password isn't valid!"));
					
				} else {
					FacesContext.getCurrentInstance().addMessage(graphValidator.getClientId(),
							new FacesMessage(FacesMessage.SEVERITY_ERROR, "Old password isn't valid!", "Old password isn't valid!"));
				}
			}
		}

		FacesContext.getCurrentInstance().addMessage(null,
				new FacesMessage(FacesMessage.SEVERITY_INFO, "Successfully changed!", "Successfully changed!"));
	}

	public UIComponent getGraphValidator() {
		return graphValidator;
	}

	public void setGraphValidator(UIComponent graphValidator) {
		this.graphValidator = graphValidator;
	}

	public String getOldPassword() {
		return oldPassword;
	}

	public void setOldPassword(String oldPassword) {
		this.oldPassword = oldPassword;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public void setConfirm(String confirm) {
		this.confirm = confirm;
	}

	public String getPassword() {
		return password;
	}

	public String getConfirm() {
		return confirm;
	}

	@Override
	public Object clone() throws CloneNotSupportedException {
		return super.clone();
	}
}