/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxshibboleth.keygenerator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;

public class Keystore {
    public static final String KEYSTORE_PKCS12 = "PKCS12";
    public static final String KEYSTORE_JKS = "JKS";
    public static final String KEYSTORE_JCEKS = "JCEKS";
    private final String filepath;
    private final String password;
    private final KeyStore keystore;

    public Keystore(String filepath, String password, String type) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this.filepath = filepath;
        this.password = password;
        this.keystore = KeyStore.getInstance(type);
        try {
            File keystoreFile = new File(filepath);
            if (keystoreFile.exists()) {
                this.keystore.load(new FileInputStream(keystoreFile), password.toCharArray());
            } else {
                this.keystore.load(null, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this.keystore.store(new FileOutputStream(this.filepath), this.password.toCharArray());
    }

    public void saveAs(String filepath, String password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this.keystore.store(new FileOutputStream(filepath), password.toCharArray());
    }

    public void deleteCertificate(String alias) throws KeyStoreException {
        this.keystore.deleteEntry(alias);
    }

    public void addCertificate(X509Certificate cert, String alias) throws KeyStoreException {
        if (this.keystore.containsAlias(alias)) {
            this.keystore.deleteEntry(alias);
        }
        this.keystore.setCertificateEntry(alias, cert);
    }

    public void addKey(SecretKey key, String alias, String password) throws KeyStoreException {
        if (this.keystore.containsAlias(alias)) {
            this.keystore.deleteEntry(alias);
        }
        this.keystore.setKeyEntry(alias, key, password.toCharArray(), null);
    }
}

