/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.service.net;

import java.io.Serializable;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.STATELESS)
@Name(value="networkService")
@AutoCreate
public class NetworkService
implements Serializable {
    private static final long serialVersionUID = -1393318600428448743L;
    @Logger
    private Log log;

    public String getRemoteIp() {
        String remoteIp = "";
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null) {
                return remoteIp;
            }
            HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
            remoteIp = request.getHeader("X-FORWARDED-FOR");
            if (StringHelper.isEmpty((String)remoteIp)) {
                remoteIp = request.getRemoteAddr();
            }
            return remoteIp;
        }
        catch (Exception ex) {
            this.log.error((Object)"Failed to get remote IP", (Throwable)ex, new Object[0]);
            return remoteIp;
        }
    }

    public static NetworkService instance() {
        return (NetworkService)Component.getInstance(NetworkService.class);
    }
}

