/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.service.metric;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.unboundid.ldap.sdk.Filter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.EntryPersistenceException;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.log.Log;
import org.xdi.ldap.model.SimpleBranch;
import org.xdi.model.ApplicationType;
import org.xdi.model.metric.MetricType;
import org.xdi.model.metric.ldap.MetricEntry;
import org.xdi.service.metric.LdapEntryReporter;
import org.xdi.util.StringHelper;

public abstract class MetricService
implements Serializable {
    private static final long serialVersionUID = -3393618600428448743L;
    private static final String EVENT_TYPE = "MetricServiceTimerEvent";
    private static final int DEFAULT_METRIC_REPORTER_INTERVAL = 60;
    private static final SimpleDateFormat PERIOD_DATE_FORMAT = new SimpleDateFormat("yyyyMM");
    private static final AtomicLong initialId = new AtomicLong(System.currentTimeMillis());
    private MetricRegistry metricRegistry;
    private Set<MetricType> registeredMetricTypes;
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;

    public void init(int metricInterval) {
        this.metricRegistry = new MetricRegistry();
        this.registeredMetricTypes = new HashSet<MetricType>();
        LdapEntryReporter ldapEntryReporter = LdapEntryReporter.forRegistry(this.metricRegistry, this.getComponentName()).build();
        int metricReporterInterval = metricInterval;
        if (metricReporterInterval <= 0) {
            metricReporterInterval = 60;
        }
        ldapEntryReporter.start(metricReporterInterval, TimeUnit.SECONDS);
    }

    @Observer(value={"MetricServiceTimerEvent"})
    @Asynchronous
    public void writeMetricEntries(List<MetricEntry> metricEntries, Date creationTime) {
        this.add(metricEntries, creationTime);
    }

    public void addBranch(String branchDn, String ou) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName(ou);
        branch.setDn(branchDn);
        this.ldapEntryManager.persist((Object)branch);
    }

    public boolean containsBranch(String branchDn) {
        return this.ldapEntryManager.contains(SimpleBranch.class, branchDn);
    }

    public void createBranch(String branchDn, String ou) {
        block2: {
            try {
                this.addBranch(branchDn, ou);
            }
            catch (EntryPersistenceException ex) {
                if (this.containsBranch(branchDn)) break block2;
                throw ex;
            }
        }
    }

    public void prepareBranch(Date creationDate, ApplicationType applicationType) {
        String baseDn = this.buildDn(null, creationDate, applicationType);
        if (!this.containsBranch(baseDn)) {
            String applicationBaseDn = this.buildDn(null, null, applicationType);
            if (!this.containsBranch(applicationBaseDn)) {
                String applianceBaseDn = this.buildDn(null, null, null);
                if (!this.containsBranch(applianceBaseDn)) {
                    this.createBranch(applianceBaseDn, this.applianceInum());
                }
                this.createBranch(applicationBaseDn, applicationType.getValue());
            }
            if (creationDate != null) {
                this.createBranch(baseDn, PERIOD_DATE_FORMAT.format(creationDate));
            }
        }
    }

    @Asynchronous
    public void add(List<MetricEntry> metricEntries, Date creationTime) {
        this.prepareBranch(creationTime, ApplicationType.OX_AUTH);
        for (MetricEntry metricEntry : metricEntries) {
            this.ldapEntryManager.persist((Object)metricEntry);
        }
    }

    public void add(MetricEntry metricEntry) {
        this.prepareBranch(metricEntry.getCreationDate(), metricEntry.getApplicationType());
        this.ldapEntryManager.persist((Object)metricEntry);
    }

    public void update(MetricEntry metricEntry) {
        this.prepareBranch(metricEntry.getCreationDate(), metricEntry.getApplicationType());
        this.ldapEntryManager.merge((Object)metricEntry);
    }

    public void remove(MetricEntry metricEntry) {
        this.prepareBranch(metricEntry.getCreationDate(), metricEntry.getApplicationType());
        this.ldapEntryManager.remove((Object)metricEntry);
    }

    public void removeBranch(String branchDn) {
        this.ldapEntryManager.removeWithSubtree(branchDn);
    }

    public MetricEntry getMetricEntryByDn(MetricType metricType, String metricEventDn) {
        return (MetricEntry)this.ldapEntryManager.find(metricType.getMetricEntryType(), (Object)metricEventDn);
    }

    public Map<MetricType, List<? extends MetricEntry>> findMetricEntry(ApplicationType applicationType, String applianceInum, List<MetricType> metricTypes, Date startDate, Date endDate, String ... returnAttributes) {
        this.prepareBranch(null, applicationType);
        HashMap<MetricType, List<? extends MetricEntry>> result = new HashMap<MetricType, List<? extends MetricEntry>>();
        if (metricTypes == null || metricTypes.size() == 0) {
            return result;
        }
        Set<String> metricDns = this.getBaseDnForPeriod(applicationType, applianceInum, startDate, endDate);
        if (metricDns.size() == 0) {
            return result;
        }
        for (MetricType metricType : metricTypes) {
            LinkedList metricTypeResult = new LinkedList();
            for (String metricDn : metricDns) {
                ArrayList<Filter> metricTypeFilters = new ArrayList<Filter>();
                Filter applicationTypeFilter = Filter.createEqualityFilter((String)"oxApplicationType", (String)applicationType.getValue());
                Filter eventTypeTypeFilter = Filter.createEqualityFilter((String)"oxMetricType", (String)metricType.getValue());
                Filter startDateFilter = Filter.createGreaterOrEqualFilter((String)"oxStartDate", (String)this.ldapEntryManager.encodeGeneralizedTime(startDate));
                Filter endDateFilter = Filter.createLessOrEqualFilter((String)"oxEndDate", (String)this.ldapEntryManager.encodeGeneralizedTime(endDate));
                metricTypeFilters.add(applicationTypeFilter);
                metricTypeFilters.add(eventTypeTypeFilter);
                metricTypeFilters.add(startDateFilter);
                metricTypeFilters.add(endDateFilter);
                Filter filter = Filter.createANDFilter(metricTypeFilters);
                List metricTypeMonthResult = this.ldapEntryManager.findEntries(metricDn, metricType.getMetricEntryType(), returnAttributes, filter);
                metricTypeResult.addAll(metricTypeMonthResult);
            }
            this.ldapEntryManager.sortListByProperties(MetricEntry.class, metricTypeResult, new String[]{"creationDate"});
            result.put(metricType, metricTypeResult);
        }
        return result;
    }

    public List<MetricEntry> getExpiredMetricEntries(String baseDnForPeriod, Date expirationDate) {
        Filter expiratioFilter = Filter.createLessOrEqualFilter((String)"oxStartDate", (String)this.ldapEntryManager.encodeGeneralizedTime(expirationDate));
        List metricEntries = this.ldapEntryManager.findEntries(baseDnForPeriod, MetricEntry.class, new String[]{"uniqueIdentifier"}, expiratioFilter);
        return metricEntries;
    }

    public Set<String> findAllPeriodBranches(ApplicationType applicationType, String applianceInum) {
        String baseDn = this.buildDn(null, null, applicationType, applianceInum);
        Filter skipRootDnFilter = Filter.createNOTFilter((Filter)Filter.createEqualityFilter((String)"ou", (String)applicationType.getValue()));
        List periodBranches = this.ldapEntryManager.findEntries(baseDn, SimpleBranch.class, new String[]{"ou"}, skipRootDnFilter);
        HashSet<String> periodBranchesStrings = new HashSet<String>();
        for (SimpleBranch periodBranch : periodBranches) {
            if (StringHelper.equalsIgnoreCase((String)baseDn, (String)periodBranch.getDn())) continue;
            periodBranchesStrings.add(periodBranch.getDn());
        }
        return periodBranchesStrings;
    }

    public void removeExpiredMetricEntries(Date expirationDate, ApplicationType applicationType, String applianceInum) {
        Set<String> keepBaseDnForPeriod = this.getBaseDnForPeriod(applicationType, applianceInum, expirationDate, new Date());
        Set<String> allBaseDnForPeriod = this.findAllPeriodBranches(applicationType, applianceInum);
        allBaseDnForPeriod.removeAll(keepBaseDnForPeriod);
        for (String baseDnForPeriod : allBaseDnForPeriod) {
            this.removeBranch(baseDnForPeriod);
        }
        for (String baseDnForPeriod : keepBaseDnForPeriod) {
            List<MetricEntry> expiredMetricEntries = this.getExpiredMetricEntries(baseDnForPeriod, expirationDate);
            for (MetricEntry expiredMetricEntry : expiredMetricEntries) {
                this.remove(expiredMetricEntry);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<String> getBaseDnForPeriod(ApplicationType applicationType, String applianceInum, Date startDate, Date endDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(startDate);
        Calendar calEndMonth = Calendar.getInstance();
        calEndMonth.setTimeZone(TimeZone.getTimeZone("UTC"));
        calEndMonth.setTime(endDate);
        int endMonth = calEndMonth.get(2);
        HashSet<String> metricDns = new HashSet<String>();
        boolean stopCondition = cal.getTime().equals(endDate);
        cal.setTime(startDate);
        while (true) {
            int currentMonth = cal.get(2);
            Date currentStartDate = cal.getTime();
            String baseDn = this.buildDn(null, currentStartDate, applicationType, applianceInum);
            if (this.containsBranch(baseDn)) {
                metricDns.add(baseDn);
            }
            if (stopCondition) return metricDns;
            cal.add(2, 1);
            if (!cal.getTime().after(endDate)) continue;
            stopCondition = true;
            if (currentMonth == endMonth) return metricDns;
        }
    }

    public String getuUiqueIdentifier() {
        return String.valueOf(initialId.incrementAndGet());
    }

    public Counter getCounter(MetricType metricType) {
        if (!this.registeredMetricTypes.contains(metricType)) {
            this.registeredMetricTypes.add(metricType);
        }
        return this.metricRegistry.counter(metricType.getMetricName());
    }

    public Timer getTimer(MetricType metricType) {
        if (!this.registeredMetricTypes.contains(metricType)) {
            this.registeredMetricTypes.add(metricType);
        }
        return this.metricRegistry.timer(metricType.getMetricName());
    }

    public void incCounter(MetricType metricType) {
        Counter counter = this.getCounter(metricType);
        counter.inc();
    }

    public String buildDn(String uniqueIdentifier, Date creationDate, ApplicationType applicationType) {
        return this.buildDn(uniqueIdentifier, creationDate, applicationType, null);
    }

    public String buildDn(String uniqueIdentifier, Date creationDate, ApplicationType applicationType, String currentApplianceInum) {
        StringBuilder dn = new StringBuilder();
        if (StringHelper.isNotEmpty((String)uniqueIdentifier) && creationDate != null && applicationType != null) {
            dn.append(String.format("uniqueIdentifier=%s,", uniqueIdentifier));
        }
        if (creationDate != null && applicationType != null) {
            dn.append(String.format("ou=%s,", PERIOD_DATE_FORMAT.format(creationDate)));
        }
        if (applicationType != null) {
            dn.append(String.format("ou=%s,", applicationType.getValue()));
        }
        if (currentApplianceInum == null) {
            dn.append(String.format("ou=%s,", this.applianceInum()));
        } else {
            dn.append(String.format("ou=%s,", currentApplianceInum));
        }
        dn.append(this.baseDn());
        return dn.toString();
    }

    public Set<MetricType> getRegisteredMetricTypes() {
        return this.registeredMetricTypes;
    }

    public abstract String baseDn();

    public abstract String applianceInum();

    public abstract String getComponentName();

    public static MetricService instance() {
        if (!Contexts.isEventContextActive() && !Contexts.isApplicationContextActive()) {
            Lifecycle.beginCall();
        }
        return (MetricService)Component.getInstance(MetricService.class);
    }
}

