/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.service.metric;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.jboss.seam.Component;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.xdi.model.ApplicationType;
import org.xdi.model.metric.MetricType;
import org.xdi.model.metric.counter.CounterMetricData;
import org.xdi.model.metric.counter.CounterMetricEntry;
import org.xdi.model.metric.ldap.MetricEntry;
import org.xdi.model.metric.timer.TimerMetricData;
import org.xdi.model.metric.timer.TimerMetricEntry;
import org.xdi.service.metric.MetricService;

public class LdapEntryReporter
extends ScheduledReporter {
    private final Clock clock;
    private final String metricServiceComponentName;
    private Date startTime;

    public static Builder forRegistry(MetricRegistry registry, String metricServiceComponentName) {
        return new Builder(registry, metricServiceComponentName);
    }

    private LdapEntryReporter(MetricRegistry registry, Clock clock, TimeZone timeZone, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, String metricServiceComponentName) {
        super(registry, "ldap-reporter", filter, rateUnit, durationUnit);
        this.clock = clock;
        this.metricServiceComponentName = metricServiceComponentName;
        this.startTime = new Date();
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        List<MetricEntry> result;
        Date currentRunTime = new Date(this.clock.getTime());
        if (!Contexts.isEventContextActive() && !Contexts.isApplicationContextActive()) {
            Lifecycle.beginCall();
        }
        MetricService metricService = (MetricService)Component.getInstance((String)this.metricServiceComponentName);
        ArrayList<MetricEntry> metricEntries = new ArrayList<MetricEntry>();
        if (counters != null && !counters.isEmpty()) {
            result = this.builCounterEntries(counters, metricService.getRegisteredMetricTypes());
            metricEntries.addAll(result);
        }
        if (timers != null && !timers.isEmpty()) {
            result = this.builTimerEntries(timers, metricService.getRegisteredMetricTypes());
            metricEntries.addAll(result);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentRunTime);
        cal.add(14, -1);
        Date endTime = cal.getTime();
        Date creationTime = new Date();
        if (metricEntries.size() > 0) {
            this.addMandatoryAttributes(metricService, this.startTime, endTime, metricEntries, creationTime);
        }
        this.startTime = currentRunTime;
        metricService.add(metricEntries, creationTime);
    }

    private List<MetricEntry> builCounterEntries(SortedMap<String, Counter> counters, Set<MetricType> registeredMetricTypes) {
        ArrayList<MetricEntry> result = new ArrayList<MetricEntry>();
        HashSet<MetricType> currentRegisteredMetricTypes = new HashSet<MetricType>(registeredMetricTypes);
        for (MetricType metricType : currentRegisteredMetricTypes) {
            Counter counter = (Counter)counters.get(metricType.getValue());
            if (counter == null) continue;
            long count = counter.getCount();
            CounterMetricData counterMetricData = new CounterMetricData(count);
            CounterMetricEntry counterMetricEntry = new CounterMetricEntry();
            counterMetricEntry.setMetricData(counterMetricData);
            counterMetricEntry.setMetricType(metricType);
            result.add((MetricEntry)counterMetricEntry);
        }
        return result;
    }

    private List<MetricEntry> builTimerEntries(SortedMap<String, Timer> timers, Set<MetricType> registeredMetricTypes) {
        ArrayList<MetricEntry> result = new ArrayList<MetricEntry>();
        for (MetricType metricType : registeredMetricTypes) {
            Timer timer = (Timer)timers.get(metricType.getValue());
            if (timer == null) continue;
            Snapshot snapshot = timer.getSnapshot();
            TimerMetricData timerMetricData = new TimerMetricData(timer.getCount(), this.convertRate(timer.getMeanRate()), this.convertRate(timer.getOneMinuteRate()), this.convertRate(timer.getFiveMinuteRate()), this.convertRate(timer.getFifteenMinuteRate()), this.getRateUnit(), this.convertDuration(snapshot.getMin()), this.convertDuration(snapshot.getMax()), this.convertDuration(snapshot.getMean()), this.convertDuration(snapshot.getStdDev()), this.convertDuration(snapshot.getMedian()), this.convertDuration(snapshot.get75thPercentile()), this.convertDuration(snapshot.get95thPercentile()), this.convertDuration(snapshot.get98thPercentile()), this.convertDuration(snapshot.get99thPercentile()), this.convertDuration(snapshot.get999thPercentile()), this.getDurationUnit());
            TimerMetricEntry timerMetricEntry = new TimerMetricEntry();
            timerMetricEntry.setMetricData(timerMetricData);
            timerMetricEntry.setMetricType(metricType);
            result.add((MetricEntry)timerMetricEntry);
        }
        return result;
    }

    private void addMandatoryAttributes(MetricService metricService, Date startTime, Date endTime, List<MetricEntry> metricEntries, Date creationTime) {
        for (MetricEntry metricEntry : metricEntries) {
            String id = metricService.getuUiqueIdentifier();
            String dn = metricService.buildDn(id, creationTime, ApplicationType.OX_AUTH);
            metricEntry.setId(id);
            metricEntry.setDn(dn);
            metricEntry.setApplicationType(ApplicationType.OX_AUTH);
            metricEntry.setStartDate(startTime);
            metricEntry.setEndDate(endTime);
            metricEntry.setCreationDate(creationTime);
        }
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private TimeZone timeZone;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private String metricServiceComponentName;

        private Builder(MetricRegistry registry, String metricServiceComponentName) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.timeZone = TimeZone.getDefault();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.metricServiceComponentName = metricServiceComponentName;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public LdapEntryReporter build() {
            return new LdapEntryReporter(this.registry, this.clock, this.timeZone, this.rateUnit, this.durationUnit, this.filter, this.metricServiceComponentName);
        }
    }
}

