/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.service.custom.script;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.log.Log;
import org.xdi.model.custom.script.CustomScriptType;
import org.xdi.model.custom.script.conf.CustomScriptConfiguration;
import org.xdi.service.custom.script.CustomScriptManager;
import org.xdi.util.StringHelper;

public class ExternalScriptService
implements Serializable {
    private static final long serialVersionUID = -1070021905117441202L;
    protected CustomScriptType customScriptType;
    protected Map<String, CustomScriptConfiguration> customScriptConfigurationsNameMap;
    protected List<CustomScriptConfiguration> customScriptConfigurations;
    protected CustomScriptConfiguration defaultExternalCustomScript;
    @Logger
    protected Log log;
    @In
    protected CustomScriptManager customScriptManager;

    public ExternalScriptService(CustomScriptType customScriptType) {
        this.customScriptType = customScriptType;
    }

    @Observer(value={"CustomScriptModifiedEvent"})
    public void reload() {
        List<CustomScriptConfiguration> newCustomScriptConfigurations = this.customScriptManager.getCustomScriptConfigurationsByScriptType(this.customScriptType);
        this.addExternalConfigurations(newCustomScriptConfigurations);
        this.customScriptConfigurations = newCustomScriptConfigurations;
        this.customScriptConfigurationsNameMap = this.buildExternalConfigurationsNameMap(this.customScriptConfigurations);
        this.defaultExternalCustomScript = this.determineDefaultCustomScriptConfiguration(this.customScriptConfigurations);
        this.reloadExternal();
    }

    protected void addExternalConfigurations(List<CustomScriptConfiguration> newCustomScriptConfigurations) {
    }

    protected void reloadExternal() {
    }

    private Map<String, CustomScriptConfiguration> buildExternalConfigurationsNameMap(List<CustomScriptConfiguration> customScriptConfigurations) {
        HashMap<String, CustomScriptConfiguration> reloadedExternalConfigurations = new HashMap<String, CustomScriptConfiguration>(customScriptConfigurations.size());
        for (CustomScriptConfiguration customScriptConfiguration : customScriptConfigurations) {
            reloadedExternalConfigurations.put(StringHelper.toLowerCase((String)customScriptConfiguration.getName()), customScriptConfiguration);
        }
        return reloadedExternalConfigurations;
    }

    public CustomScriptConfiguration determineDefaultCustomScriptConfiguration(List<CustomScriptConfiguration> customScriptConfigurations) {
        CustomScriptConfiguration defaultExternalCustomScript = null;
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurations) {
            if (defaultExternalCustomScript != null && defaultExternalCustomScript.getLevel() < customScriptConfiguration.getLevel()) continue;
            defaultExternalCustomScript = customScriptConfiguration;
        }
        return defaultExternalCustomScript;
    }

    public boolean isEnabled() {
        if (this.customScriptConfigurations == null) {
            return false;
        }
        return this.customScriptConfigurations.size() > 0;
    }

    public CustomScriptConfiguration getCustomScriptConfigurationByName(String name) {
        return this.customScriptConfigurationsNameMap.get(StringHelper.toLowerCase((String)name));
    }

    public CustomScriptConfiguration getDefaultExternalCustomScript() {
        return this.defaultExternalCustomScript;
    }

    public List<CustomScriptConfiguration> getCustomScriptConfigurations() {
        return this.customScriptConfigurations;
    }
}

